/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XML {
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public static Document getDocument(String string, final StringBuilder stringBuilder) {
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                    this.appendError(sAXParseException);
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    this.appendError(sAXParseException);
                }

                @Override
                public void warning(SAXParseException sAXParseException) throws SAXException {
                    this.appendError(sAXParseException);
                }

                private void appendError(SAXParseException sAXParseException) {
                    if (stringBuilder != null) {
                        stringBuilder.append(sAXParseException.getMessage()).append(" (line: ").append(sAXParseException.getLineNumber());
                        stringBuilder.append(", column: ").append(sAXParseException.getColumnNumber()).append(")");
                    }
                }
            });
            return documentBuilder.parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getFirstElement(Document document, String string) {
        Node node = document.getElementsByTagName(string).item(0);
        if (node == null) {
            return null;
        }
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    public static String getAttribute(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    public static String prettyPrint(String string, StringBuilder stringBuilder) {
        Document document = XML.getDocument(string, stringBuilder);
        if (document != null) {
            return XML.prettyPrint(document);
        }
        return null;
    }

    public static final String prettyPrint(Document document) {
        OutputFormat outputFormat = new OutputFormat(document);
        outputFormat.setEncoding(document.getXmlEncoding());
        outputFormat.setLineWidth(65);
        outputFormat.setIndenting(true);
        outputFormat.setIndent(2);
        StringWriter stringWriter = new StringWriter();
        XMLSerializer xMLSerializer = new XMLSerializer(stringWriter, outputFormat);
        try {
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return ((Object)stringWriter).toString();
    }

    public static String getElementValue(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            return node2.getTextContent();
        }
        return "";
    }
}

