/*
 * Decompiled with CFR 0.152.
 */
package network.persistent;

import gui.GUI;
import network.ConnectionHandler;

public class ReconnectThread
extends Thread {
    private static final int MAX_TRIES = 5;
    private ConnectionHandler connectionHandler;
    private GUI gui;

    public ReconnectThread(ConnectionHandler connectionHandler, GUI gUI) {
        super("ReconnectThread");
        this.connectionHandler = connectionHandler;
        this.gui = gUI;
    }

    @Override
    public void run() {
        boolean bl = false;
        for (int i = 0; i < 5 && !this.isInterrupted(); ++i) {
            this.gui.logSystemMessage("Trying to reconnect, try " + (i + 1) + " of " + 5 + "...");
            if (this.connectionHandler.connect()) {
                bl = true;
                break;
            }
            if (this.isInterrupted()) break;
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (!bl) {
            this.gui.logErrorMessage("Failed to reconnect");
            this.connectionHandler.disconnectWithoutReconnect();
        }
    }
}

