/*
 * Decompiled with CFR 0.152.
 */
package network.persistent;

import gui.GUI;
import java.io.BufferedWriter;
import java.io.IOException;
import network.ConnectionHandler;
import network.OutputBuffer;

public class PersistentWriter
extends Thread {
    private BufferedWriter writer;
    private OutputBuffer outputBuffer;
    private ConnectionHandler connectionHandler;
    private GUI gui;

    public PersistentWriter(BufferedWriter bufferedWriter, OutputBuffer outputBuffer, ConnectionHandler connectionHandler, GUI gUI) {
        super("PersistentWriter");
        this.writer = bufferedWriter;
        this.outputBuffer = outputBuffer;
        this.connectionHandler = connectionHandler;
        this.gui = gUI;
    }

    @Override
    public void run() {
        while (true) {
            OutputBuffer.Packet packet = null;
            try {
                packet = this.outputBuffer.get();
                this.writer.write(packet.getXml());
                this.writer.newLine();
                this.writer.flush();
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            catch (IOException iOException) {
                if (packet == null) break;
                packet.setHasError(this.gui);
                break;
            }
        }
        this.connectionHandler.disconnect();
    }
}

