/*
 * Decompiled with CFR 0.152.
 */
package network.persistent;

import activity.ActivityManager;
import activity.IdRegister;
import gui.GUI;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import network.Connection;
import network.ConnectionHandler;
import network.InputHandler;
import network.NetworkReader;
import network.OutputBuffer;
import network.PacketHandler;
import network.SupervisionHandler;
import network.persistent.PersistentWriter;
import network.persistent.ReconnectThread;

public class ConnectionPersistent
extends Connection {
    private Socket socket;
    private OutputBuffer outputBuffer;
    private boolean connected = false;
    private boolean doReconnect = true;
    private ReconnectThread reconnectThread;

    public ConnectionPersistent(PacketHandler packetHandler, IdRegister idRegister, ActivityManager activityManager, GUI gUI, SupervisionHandler supervisionHandler, ConnectionHandler connectionHandler) {
        super(packetHandler, idRegister, activityManager, gUI, supervisionHandler, connectionHandler);
    }

    @Override
    public boolean connect() {
        try {
            this.gui.logSystemMessage("Connecting to " + this.host + ":" + this.serverPort + "...");
            this.socket = new Socket();
            this.socket.setTcpNoDelay(true);
            this.socket.connect(new InetSocketAddress(this.host, this.serverPort), 500);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), this.charset));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), this.charset));
            InputHandler inputHandler = new InputHandler(this.gui, this.packetHandler, this.idRegister);
            this.outputBuffer = new OutputBuffer(this.gui);
            NetworkReader networkReader = new NetworkReader(bufferedReader, inputHandler, this.connectionHandler, true, null);
            PersistentWriter persistentWriter = new PersistentWriter(bufferedWriter, this.outputBuffer, this.connectionHandler, this.gui);
            networkReader.start();
            persistentWriter.start();
            this.startServer();
            this.connected = true;
            this.doReconnect = true;
            this.gui.setConnected(this.host + ":" + this.serverPort, Connection.ConnectionType.PERSISTENT);
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            this.gui.logErrorMessage("Could not find host: " + unknownHostException.getMessage());
        }
        catch (Exception exception) {
            this.gui.logErrorMessage("Connection error: " + exception.getMessage());
        }
        return false;
    }

    @Override
    public void disconnectWithoutReconnect() {
        this.doReconnect = false;
        this.disconnect();
    }

    @Override
    public void disconnect() {
        if (this.connected && this.doReconnect) {
            this.gui.logErrorMessage("Connection to server closed.");
            this.stopServer();
            this.outputBuffer.close();
            this.outputBuffer = null;
            this.connected = false;
            this.reconnectThread = new ReconnectThread(this.connectionHandler, this.gui);
            this.reconnectThread.start();
        } else if (this.connected) {
            try {
                this.stopServer();
                this.socket.close();
                this.outputBuffer.close();
                this.outputBuffer = null;
                this.connected = false;
                this.gui.setDisconnected();
                this.activityManager.stopAll();
                this.supervisionHandler.stop();
                this.gui.logErrorMessage("Connection to server closed.");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (!this.doReconnect && this.reconnectThread != null && this.reconnectThread.isAlive()) {
            this.gui.logErrorMessage("Connection to server closed.");
            this.reconnectThread.interrupt();
            this.gui.setDisconnected();
            this.activityManager.stopAll();
            this.supervisionHandler.stop();
        }
    }

    @Override
    public void sendPacket(OutputBuffer.Packet packet) {
        if (this.connected) {
            this.outputBuffer.put(packet);
        } else {
            packet.setHasError(this.gui);
        }
    }
}

