/*
 * Decompiled with CFR 0.152.
 */
package network.multiple;

import activity.IdRegister;
import gui.GUI;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import network.Connection;
import network.InputHandler;
import network.OutputBuffer;
import network.PacketHandler;

public class MultipleWriter
extends Thread {
    private OutputBuffer outputBuffer;
    private Connection connection;
    private GUI gui;
    private StringBuilder stringBuilder;
    private InputHandler inputHandler;

    public MultipleWriter(Connection connection, OutputBuffer outputBuffer, GUI gUI, PacketHandler packetHandler, IdRegister idRegister) {
        super("MultipleWriter");
        this.connection = connection;
        this.outputBuffer = outputBuffer;
        this.gui = gUI;
        this.stringBuilder = new StringBuilder(1000);
        this.inputHandler = new InputHandler(gUI, packetHandler, idRegister);
    }

    @Override
    public void run() {
        while (true) {
            OutputBuffer.Packet packet = null;
            try {
                Socket socket;
                packet = this.outputBuffer.get();
                boolean bl = false;
                if (packet.getSocket() != null) {
                    socket = packet.getSocket();
                    bl = packet.getKeepSocket();
                } else {
                    socket = new Socket();
                    socket.setTcpNoDelay(true);
                    socket.connect(new InetSocketAddress(this.connection.getHost(), this.connection.getPort()), 250);
                }
                String string = this.connection.getCharset();
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), string));
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), string));
                bufferedWriter.write(packet.getXml());
                bufferedWriter.newLine();
                bufferedWriter.flush();
                if (!bl) {
                    socket.shutdownOutput();
                }
                this.readResponses(bufferedReader);
                if (bl) continue;
                socket.close();
                continue;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                if (packet == null) continue;
                packet.setHasError(this.gui);
                continue;
            }
            break;
        }
    }

    private void readResponses(BufferedReader bufferedReader) throws IOException {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                this.stringBuilder.append(string + "\n");
                if (!string.startsWith("</OAP-response>") && !string.startsWith("</OAP-request>") && !string.endsWith("</OAP-response>") && !string.endsWith("</OAP-request>")) continue;
                this.inputHandler.handle(this.stringBuilder.toString(), null);
                this.stringBuilder.setLength(0);
            }
        }
        catch (IOException iOException) {
        }
    }
}

