/*
 * Decompiled with CFR 0.152.
 */
package network.multiple;

import activity.ActivityManager;
import activity.IdRegister;
import gui.GUI;
import network.Connection;
import network.ConnectionHandler;
import network.OutputBuffer;
import network.PacketHandler;
import network.SupervisionHandler;
import network.multiple.MultipleWriter;

public class ConnectionMultiple
extends Connection {
    private OutputBuffer outputBuffer;
    private boolean connected = false;

    public ConnectionMultiple(PacketHandler packetHandler, IdRegister idRegister, ActivityManager activityManager, GUI gUI, SupervisionHandler supervisionHandler, ConnectionHandler connectionHandler) {
        super(packetHandler, idRegister, activityManager, gUI, supervisionHandler, connectionHandler);
    }

    @Override
    public boolean connect() {
        this.startServer();
        this.outputBuffer = new OutputBuffer(this.gui);
        MultipleWriter multipleWriter = new MultipleWriter(this, this.outputBuffer, this.gui, this.packetHandler, this.idRegister);
        multipleWriter.start();
        this.gui.setConnected(this.host + ":" + this.serverPort, Connection.ConnectionType.MULTIPLE);
        this.connected = true;
        return true;
    }

    @Override
    public void disconnect() {
        if (this.connected) {
            this.outputBuffer.close();
            this.stopServer();
            this.gui.setDisconnected();
            this.connected = false;
        }
    }

    @Override
    public void disconnectWithoutReconnect() {
        this.disconnect();
    }

    @Override
    public void sendPacket(OutputBuffer.Packet packet) {
        this.outputBuffer.put(packet);
    }
}

