/*
 * Decompiled with CFR 0.152.
 */
package network;

import java.text.DecimalFormat;
import network.PacketHandler;
import network.VersionData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import utils.XML;

public class VersionDataV4
extends VersionData {
    public static final int DEFAULT_PORT = 1322;
    public static final String DEFAULT_CHARSET = "UTF-8";

    @Override
    protected String getTypeUserData() {
        return "User_data";
    }

    @Override
    protected String getTypeAlarm() {
        return "Alarm";
    }

    @Override
    protected String getRequestXML(String string, String string2, int n, PacketHandler.PacketInfo packetInfo) {
        String string3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        DecimalFormat decimalFormat = new DecimalFormat("#.#");
        string3 = string3 + "<OAP-request version=\"" + decimalFormat.format(packetInfo.sendVersion.value()) + "\" id=\"" + string + "\">\n";
        if (packetInfo.appendHeader) {
            string3 = string3 + "<Header>\n";
            string3 = string3 + "<Port>" + n + "</Port>\n";
            if (packetInfo.to != null) {
                string3 = string3 + "<To>" + packetInfo.to + "</To>\n";
            }
            if (packetInfo.availabilityStatus) {
                string3 = string3 + "<AvailabilityStatus />\n";
            }
            if (packetInfo.deliveryStatus) {
                string3 = string3 + "<DeliveryStatus />\n";
            }
            string3 = string3 + "</Header>\n";
        }
        string3 = string3 + packetInfo.xml + "\n";
        string3 = string3 + "</OAP-request>\n";
        return string3;
    }

    @Override
    protected String getResponseXML(String string, String string2, int n, int n2) {
        String string3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        string3 = string3 + "<OAP-response version=\"4.0\" id=\"" + string + "\">";
        string3 = string3 + "<Status>";
        string3 = string3 + "<Type>" + n + "</Type>";
        string3 = string3 + "<Code>" + n2 + "</Code>";
        string3 = string3 + "</Status>";
        string3 = string3 + "</OAP-response>\n";
        return string3;
    }

    @Override
    protected String getServiceName(Document document) {
        Node node = document.getElementsByTagName("Body").item(0);
        if (node == null) {
            return null;
        }
        String string = XML.getAttribute(node, "service");
        if (string.equals("OA-XML")) {
            Node node2 = document.getElementsByTagName("service").item(0);
            NodeList nodeList = node2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node3 = nodeList.item(i);
                if (node3.getNodeType() != 1 || node3.getNodeName().equals("Id")) continue;
                string = node3.getNodeName();
                break;
            }
            if (string == null) {
                string = null;
            }
        }
        return string;
    }
}

