/*
 * Decompiled with CFR 0.152.
 */
package network;

import activity.ActivityData;
import activity.IdRegister;
import gui.GUI;
import gui.tab.Request;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;
import network.ConnectionHandler;
import network.OutputBuffer;
import network.VersionData;
import network.VersionDataV3;
import network.VersionDataV4;
import org.w3c.dom.Document;
import utils.XML;

public class PacketHandler {
    private IdRegister idRegister;
    private GUI gui;
    private ConnectionHandler connectionHandler;
    private VersionData versionDataV3;
    private VersionData versionDataV4;
    private long id;
    private String localIp;
    private LocalPort localPort;
    private int acceptRespCode = 200;
    private int availRespCode = 200;
    private int delivRespCode = 200;

    public void SetAcceptRespCode(int n) {
        this.acceptRespCode = n;
    }

    public void SetAvailRespCode(int n) {
        this.availRespCode = n;
    }

    public void SetDelivRespCode(int n) {
        this.delivRespCode = n;
    }

    public PacketHandler(IdRegister idRegister) {
        this.idRegister = idRegister;
        Random random = new Random();
        this.id = (long)random.nextInt(65536) << 16;
        this.versionDataV3 = new VersionDataV3();
        this.versionDataV4 = new VersionDataV4();
        this.localPort = new LocalPort();
        try {
            this.localIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.gui.logErrorMessage("Failed to get local IP: " + unknownHostException.getMessage());
        }
    }

    public synchronized void setConnectionHandler(ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public synchronized void setGui(GUI gUI) {
        this.gui = gUI;
    }

    public void setLocalPort(int n) {
        this.localPort.set(n);
    }

    public synchronized void sendAddClient(int n, boolean bl) {
        String string = "<Body service=\"addClient\"> \n";
        if (bl) {
            string = string + "<UpdTime>" + n + "</UpdTime>\n";
        }
        string = string + "</Body>\n";
        this.sendPacket(string);
    }

    public synchronized void sendRemoveClient() {
        String string = "<Body service=\"removeClient\">\n";
        string = string + "</Body>";
        this.sendPacket(string);
    }

    public synchronized void sendSubscriptionStartUserData() {
        String string = this.getVersionData().getTypeUserData();
        this.sendSubscriptionStart(string);
    }

    public synchronized void sendSubscriptionStartAlarm() {
        String string = this.getVersionData().getTypeAlarm();
        this.sendSubscriptionStart(string);
    }

    private void sendSubscriptionStart(String string) {
        String string2 = "";
        string2 = string2 + "<Body service=\"subscriptionStart\">\n";
        string2 = string2 + "<Service>" + string + "</Service>\n";
        string2 = string2 + "</Body>\n";
        this.sendPacket(string2);
    }

    public synchronized void sendSubscriptionStopUserData() {
        String string = this.getVersionData().getTypeUserData();
        this.sendSubscriptionStop(string);
    }

    public synchronized void sendSubscriptionStopAlarm() {
        String string = this.getVersionData().getTypeAlarm();
        this.sendSubscriptionStop(string);
    }

    private void sendSubscriptionStop(String string) {
        String string2 = "";
        string2 = string2 + "<Body service=\"subscriptionStop\">\n";
        string2 = string2 + "<Service>" + string + "</Service>\n";
        string2 = string2 + "</Body>\n";
        this.sendPacket(string2);
    }

    public synchronized String getRequestXml(PacketInfo packetInfo) {
        return this.getVersionData().getRequestXML("", this.localIp, this.localPort.get(), packetInfo);
    }

    public synchronized String getService(Document document) {
        return this.getVersionData().getServiceName(document);
    }

    public synchronized void sendPacket(String string) {
        this.sendPacket(new PacketInfo(true, string), null, null);
    }

    public synchronized void sendPacket(PacketInfo packetInfo, String string, ActivityData activityData) {
        String string2 = Long.toHexString(this.id);
        String string3 = this.getVersionData().getRequestXML(string2, this.localIp, this.localPort.get(), packetInfo);
        String string4 = null;
        Document document = XML.getDocument(string3, null);
        if (document != null) {
            string4 = this.getVersionData().getServiceName(document);
        }
        this.gui.addRequest(Request.Direction.OUT, string4, string2, string, string3);
        this.idRegister.registerRequest(this.id, activityData);
        this.connectionHandler.sendPacket(new OutputBuffer.Packet(string3, string2, string4, activityData, OutputBuffer.Packet.Type.REQUEST, null, false));
        this.id = this.id == -1L ? 1L : ++this.id;
    }

    public synchronized void sendResponse(String string, String string2, Socket socket, boolean bl, boolean bl2) {
        String string3;
        boolean bl3;
        boolean bl4;
        boolean bl5 = bl && this.availRespCode != 0;
        boolean bl6 = bl4 = bl2 && this.delivRespCode != 0;
        if (this.acceptRespCode != 0) {
            bl3 = bl5 || bl4;
            string3 = this.getVersionData().getResponseXML(string2, string, 1, this.acceptRespCode);
            this.gui.addResponse(Request.Direction.IN, string2, 1, this.acceptRespCode, string3, false);
            this.connectionHandler.sendPacket(new OutputBuffer.Packet(string3, string2, string, null, OutputBuffer.Packet.Type.RESPONSE, socket, bl3));
        }
        if (bl5) {
            bl3 = bl4;
            string3 = this.getVersionData().getResponseXML(string2, string, 2, this.availRespCode);
            this.gui.addResponse(Request.Direction.IN, string2, 2, this.availRespCode, string3, false);
            this.connectionHandler.sendPacket(new OutputBuffer.Packet(string3, string2, string, null, OutputBuffer.Packet.Type.RESPONSE, socket, bl3));
        }
        if (bl4) {
            string3 = this.getVersionData().getResponseXML(string2, string, 3, this.delivRespCode);
            this.gui.addResponse(Request.Direction.IN, string2, 3, this.delivRespCode, string3, false);
            this.connectionHandler.sendPacket(new OutputBuffer.Packet(string3, string2, string, null, OutputBuffer.Packet.Type.RESPONSE, socket, false));
        }
    }

    private VersionData getVersionData() {
        if (GUI.getVersion() == GUI.Version.V3) {
            return this.versionDataV3;
        }
        return this.versionDataV4;
    }

    public static class PacketInfo {
        public boolean appendHeader;
        public String xml;
        public String to;
        public boolean availabilityStatus;
        public boolean deliveryStatus;
        GUI.Version sendVersion;

        public PacketInfo(boolean bl, String string) {
            this(bl, string, null, false, false, GUI.getVersion());
        }

        public PacketInfo(boolean bl, String string, String string2, boolean bl2, boolean bl3, GUI.Version version) {
            this.appendHeader = bl;
            this.xml = string;
            this.to = string2;
            this.availabilityStatus = bl2;
            this.deliveryStatus = bl3;
            this.sendVersion = version;
        }
    }

    public class LocalPort {
        private int port;

        public synchronized void set(int n) {
            this.port = n;
        }

        public synchronized int get() {
            return this.port;
        }
    }
}

