/*
 * Decompiled with CFR 0.152.
 */
package network;

import activity.ActivityData;
import gui.GUI;
import java.net.Socket;
import java.util.LinkedList;

public class OutputBuffer {
    private static final int MAX_SIZE = 1000;
    private GUI gui;
    private boolean killed;
    private LinkedList<Packet> list;

    public OutputBuffer(GUI gUI) {
        this.gui = gUI;
        this.killed = false;
        this.list = new LinkedList();
    }

    public synchronized Packet get() throws InterruptedException {
        while (this.list.isEmpty() && !this.killed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.killed) {
            throw new InterruptedException();
        }
        return this.list.removeFirst();
    }

    public boolean isEmpty() {
        return this.killed || this.list.isEmpty();
    }

    public synchronized void put(Packet packet) {
        if (this.killed) {
            return;
        }
        if (this.list.size() > 1000) {
            packet.setHasError(this.gui, "send queue full");
            return;
        }
        this.list.addLast(packet);
        this.notifyAll();
    }

    public synchronized void close() {
        this.killed = true;
        this.list.clear();
        this.notifyAll();
    }

    public static class Packet {
        private String xml;
        private String id;
        private String service;
        private ActivityData activityData;
        private Type type;
        private Socket socket;
        private boolean keepSocket;

        public Packet(String string, String string2, String string3, ActivityData activityData, Type type, Socket socket, boolean bl) {
            this.xml = string;
            this.id = string2;
            this.service = string3;
            this.activityData = activityData;
            this.type = type;
            this.socket = socket;
            this.keepSocket = bl;
        }

        public String getXml() {
            return this.xml;
        }

        public void setHasError(GUI gUI) {
            this.setHasError(gUI, null);
        }

        public void setHasError(GUI gUI, String string) {
            if (this.activityData != null) {
                this.activityData.addRequestSendError();
            }
            switch (this.type) {
                case REQUEST: {
                    gUI.addRequestSendError(this.service, this.id, string);
                    break;
                }
                case RESPONSE: {
                    gUI.addResponseSendError(this.service, this.id, string);
                }
            }
        }

        public String getId() {
            return this.id;
        }

        public Socket getSocket() {
            return this.socket;
        }

        public boolean getKeepSocket() {
            return this.keepSocket;
        }

        public static enum Type {
            REQUEST,
            RESPONSE;

        }
    }
}

