/*
 * Decompiled with CFR 0.152.
 */
package network;

import activity.IdRegister;
import gui.GUI;
import gui.tab.Request;
import java.io.IOException;
import java.net.Socket;
import network.PacketHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import utils.XML;

public class InputHandler {
    private GUI gui;
    private PacketHandler packetHandler;
    private IdRegister idRegister;

    public InputHandler(GUI gUI, PacketHandler packetHandler, IdRegister idRegister) {
        this.gui = gUI;
        this.packetHandler = packetHandler;
        this.idRegister = idRegister;
    }

    public void handle(String string, Socket socket) {
        StringBuilder stringBuilder = new StringBuilder();
        Document document = XML.getDocument(string, stringBuilder);
        if (document != null) {
            boolean bl;
            boolean bl2 = document.getElementsByTagName("OAP-request").getLength() == 1;
            boolean bl3 = bl = document.getElementsByTagName("OAP-response").getLength() == 1;
            if (bl2) {
                this.handleRequest(document, string, socket);
            } else if (bl) {
                this.handleResponse(document, string, socket);
            }
        } else {
            this.gui.logErrorMessage("XML error in message from server: " + stringBuilder.toString());
        }
    }

    private void handleRequest(Document document, String string, Socket socket) {
        Node node = document.getElementsByTagName("OAP-request").item(0);
        if (!this.checkVersion("request", node)) {
            return;
        }
        String string2 = XML.getAttribute(node, "id");
        String string3 = this.packetHandler.getService(document);
        Element element = (Element)node;
        Element element2 = (Element)element.getElementsByTagName("Header").item(0);
        if (element2 == null) {
            string3 = "Syntax error: Request missing <Header> element";
            this.gui.addRequest(Request.Direction.IN, string3, String.valueOf(string2), "", string);
            return;
        }
        boolean bl = element2.getElementsByTagName("AvailabilityStatus").getLength() >= 1;
        boolean bl2 = element2.getElementsByTagName("DeliveryStatus").getLength() >= 1;
        this.gui.addRequest(Request.Direction.IN, string3, String.valueOf(string2), "", string);
        this.packetHandler.sendResponse(string3, string2, socket, bl, bl2);
    }

    private void handleResponse(Document document, String string, Socket socket) {
        Node node = document.getElementsByTagName("OAP-response").item(0);
        if (!this.checkVersion("response", node)) {
            return;
        }
        Node node2 = node.getAttributes().getNamedItem("id");
        if (node2 == null) {
            this.gui.logErrorMessage("Failed to find id in incoming response");
            return;
        }
        String string2 = node2.getNodeValue();
        boolean bl = false;
        String string3 = XML.getFirstElement(document, "Type");
        int n = -1;
        if (string3 == null) {
            bl = true;
        } else {
            n = Integer.valueOf(string3);
        }
        String string4 = XML.getFirstElement(document, "Code");
        int n2 = -1;
        if (string4 == null) {
            bl = true;
        } else {
            n2 = Integer.valueOf(string4);
        }
        this.gui.addResponse(Request.Direction.OUT, string2, n, n2, string, bl);
        if (!this.idRegister.registerResponse(Long.decode("#" + string2), n, n2)) {
            this.gui.logErrorMessage("Failed to find request with id " + string2);
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean checkVersion(String string, Node node) {
        double d;
        double d2 = Double.valueOf(XML.getAttribute(node, "version"));
        if (!(d2 >= (d = GUI.getVersion().value())) || !(d2 < d + 1.0)) {
            String string2 = "Received " + string + " with wrong version ";
            string2 = string2 + "(got: " + d2 + ", wanted: " + d + ")";
            this.gui.logErrorMessage(string2);
            return false;
        }
        return true;
    }
}

