/*
 * Decompiled with CFR 0.152.
 */
package network;

import activity.ActivityManager;
import activity.IdRegister;
import gui.GUI;
import network.Connection;
import network.OutputBuffer;
import network.PacketHandler;
import network.SupervisionHandler;
import network.multiple.ConnectionMultiple;
import network.persistent.ConnectionPersistent;

public class ConnectionHandler {
    private Connection connection;
    private PacketHandler packetHandler;
    private IdRegister idRegister;
    private ActivityManager activityManager;
    private GUI gui;
    private SupervisionHandler supervisionHandler;

    public ConnectionHandler(PacketHandler packetHandler, IdRegister idRegister, ActivityManager activityManager, SupervisionHandler supervisionHandler) {
        this.packetHandler = packetHandler;
        this.idRegister = idRegister;
        this.activityManager = activityManager;
        this.supervisionHandler = supervisionHandler;
    }

    public synchronized void setGui(GUI gUI) {
        this.gui = gUI;
    }

    public synchronized void setConnectionType(Connection.ConnectionType connectionType) {
        if (this.connection != null) {
            this.connection.disconnectWithoutReconnect();
        }
        switch (connectionType) {
            case PERSISTENT: {
                this.connection = new ConnectionPersistent(this.packetHandler, this.idRegister, this.activityManager, this.gui, this.supervisionHandler, this);
                break;
            }
            case MULTIPLE: {
                this.connection = new ConnectionMultiple(this.packetHandler, this.idRegister, this.activityManager, this.gui, this.supervisionHandler, this);
            }
        }
    }

    public synchronized void connect(String string, boolean bl, int n, boolean bl2) {
        String string2;
        int n2;
        if (GUI.getVersion() == GUI.Version.V3) {
            n2 = 1321;
            string2 = "ISO-8859-1";
        } else {
            n2 = 1322;
            string2 = "UTF-8";
        }
        if (!bl) {
            n2 = n;
        }
        this.connection.setCharset(string2);
        this.connection.setHost(string);
        this.connection.setServerPort(n2);
        this.connection.setAutoReconnect(bl2);
        this.connection.connect();
    }

    public synchronized boolean connect() {
        if (this.connection != null) {
            return this.connection.connect();
        }
        return false;
    }

    public synchronized void disconnect() {
        this.connection.disconnect();
    }

    public synchronized void disconnectWithoutReconnect() {
        this.connection.disconnectWithoutReconnect();
    }

    public synchronized void sendPacket(OutputBuffer.Packet packet) {
        if (this.connection != null) {
            this.connection.sendPacket(packet);
        } else {
            this.gui.logErrorMessage("Failed to send packet (id: " + packet.getId() + "): not connected");
        }
    }
}

