/*
 * Decompiled with CFR 0.152.
 */
package network;

import activity.ActivityManager;
import activity.IdRegister;
import gui.GUI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import network.ConnectionHandler;
import network.InputHandler;
import network.NetworkReader;
import network.OutputBuffer;
import network.PacketHandler;
import network.SupervisionHandler;

public abstract class Connection {
    protected String host;
    protected int serverPort;
    protected String charset;
    protected boolean autoReconnect;
    protected String localIp;
    protected int localPort;
    protected PacketHandler packetHandler;
    protected IdRegister idRegister;
    protected ActivityManager activityManager;
    protected GUI gui;
    protected SupervisionHandler supervisionHandler;
    protected ConnectionHandler connectionHandler;
    private Thread serverThread;

    public Connection(PacketHandler packetHandler, IdRegister idRegister, ActivityManager activityManager, GUI gUI, SupervisionHandler supervisionHandler, ConnectionHandler connectionHandler) {
        this.packetHandler = packetHandler;
        this.idRegister = idRegister;
        this.activityManager = activityManager;
        this.gui = gUI;
        this.supervisionHandler = supervisionHandler;
        this.connectionHandler = connectionHandler;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setServerPort(int n) {
        this.serverPort = n;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public void setAutoReconnect(boolean bl) {
        this.autoReconnect = bl;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.serverPort;
    }

    public String getCharset() {
        return this.charset;
    }

    protected void startServer() {
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            this.localPort = serverSocket.getLocalPort();
            this.packetHandler.setLocalPort(this.localPort);
            this.gui.logSystemMessage("Listening on port " + this.localPort);
            this.serverThread = new ServerThread(serverSocket);
            this.serverThread.start();
        }
        catch (IOException iOException) {
            this.gui.logErrorMessage("Failed to start local server: " + iOException.getMessage());
        }
    }

    protected void stopServer() {
        if (this.serverThread != null) {
            this.serverThread.interrupt();
            try {
                Socket socket = new Socket("localhost", this.localPort);
                socket.close();
                this.serverThread.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public abstract boolean connect();

    public abstract void disconnect();

    public abstract void disconnectWithoutReconnect();

    public abstract void sendPacket(OutputBuffer.Packet var1);

    private class ServerThread
    extends Thread {
        private ServerSocket serverSocket;

        public ServerThread(ServerSocket serverSocket) {
            super("ServerThread");
            this.serverSocket = serverSocket;
        }

        @Override
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Socket socket = this.serverSocket.accept();
                    if (!this.isInterrupted()) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        InputHandler inputHandler = new InputHandler(Connection.this.gui, Connection.this.packetHandler, Connection.this.idRegister);
                        NetworkReader networkReader = new NetworkReader(bufferedReader, inputHandler, Connection.this.connectionHandler, false, socket);
                        networkReader.start();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                Connection.this.gui.logErrorMessage("Local server, IO error: " + iOException.getMessage());
            }
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static enum ConnectionType {
        PERSISTENT,
        MULTIPLE;

    }
}

