/*
 * Decompiled with CFR 0.152.
 */
package gui.usermessages;

import gui.GUI;
import gui.usermessages.EditDialog;
import gui.usermessages.Message;
import gui.usermessages.MessageList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class ViewAllDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int INDEX_VIEW_V3 = 0;
    private static final int INDEX_VIEW_V4 = 1;
    private JList list;
    private MessageList messageList;
    private int nextMessageId = 1;
    private JComboBox versionBox;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private JButton saveButton;
    private JButton cancelButton;

    public ViewAllDialog(JFrame jFrame) {
        super(jFrame);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.messageList = new MessageList();
        if (this.messageList.hasError()) {
            return;
        }
        this.list = new JList(this.messageList);
        if (this.messageList.getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
        JScrollPane jScrollPane = new JScrollPane(this.list, 20, 30);
        this.list.setVisibleRowCount(20);
        jScrollPane.setPreferredSize(new Dimension(200, 324));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 0;
        this.add((Component)jScrollPane, gridBagConstraints);
        String[] stringArray = new String[]{"Version 3", "Version 4"};
        this.versionBox = new JComboBox<String>(stringArray);
        this.versionBox.addActionListener(this);
        if (GUI.getVersion() == GUI.Version.V3) {
            this.versionBox.setSelectedIndex(0);
        } else {
            this.versionBox.setSelectedIndex(1);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 30, 5);
        this.add((Component)this.versionBox, gridBagConstraints);
        this.addButton = new JButton("Add");
        this.editButton = new JButton("Edit");
        this.removeButton = new JButton("Remove");
        this.addButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.addButton.setPreferredSize(new Dimension(73, 23));
        this.editButton.setPreferredSize(new Dimension(73, 23));
        this.removeButton.setPreferredSize(new Dimension(73, 23));
        gridBagConstraints.insets = new Insets(0, 5, 3, 5);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.addButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.editButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.removeButton, gridBagConstraints);
        this.saveButton = new JButton("Save");
        this.cancelButton = new JButton("Cancel");
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.saveButton.setPreferredSize(new Dimension(73, 23));
        this.cancelButton.setPreferredSize(new Dimension(73, 23));
        this.cancelButton.setActionCommand("close");
        gridBagConstraints.insets = new Insets(140, 5, 3, 5);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.saveButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 5, 3, 5);
        gridBagConstraints.gridy = 5;
        this.add((Component)this.cancelButton, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.saveButton);
        this.getRootPane().registerKeyboardAction(this, "close", KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("User messages");
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("close")) {
            this.dispose();
        } else if (actionEvent.getSource() == this.addButton) {
            this.newMessage();
        } else if (actionEvent.getSource() == this.removeButton) {
            this.removeSelected();
        } else if (actionEvent.getSource() == this.editButton) {
            this.editSelected();
        } else if (actionEvent.getSource() == this.saveButton) {
            this.messageList.saveToFile();
            this.dispose();
        } else if (actionEvent.getSource() == this.versionBox) {
            this.changeView();
        }
    }

    private void newMessage() {
        GUI.Version version = GUI.getVersion();
        switch (this.versionBox.getSelectedIndex()) {
            case 0: {
                version = GUI.Version.V3;
                break;
            }
            case 1: {
                version = GUI.Version.V4;
            }
        }
        Message message = new Message("Message " + this.nextMessageId, version, true, "");
        this.messageList.add(message);
        ++this.nextMessageId;
    }

    private void changeView() {
        switch (this.versionBox.getSelectedIndex()) {
            case 0: {
                this.messageList.viewV3Only();
                break;
            }
            case 1: {
                this.messageList.viewV4Only();
            }
        }
    }

    private void editSelected() {
        int n = this.list.getSelectedIndex();
        if (n >= 0) {
            new EditDialog(this.messageList, this.messageList.getElementAt(n), this);
        }
    }

    private void removeSelected() {
        int n = this.list.getSelectedIndex();
        if (n >= 0) {
            this.messageList.remove(n);
            int n2 = this.messageList.getSize() - 1 < n ? this.messageList.getSize() - 1 : n;
            if (n2 >= 0) {
                this.list.setSelectedIndex(n2);
            }
        }
    }
}

