/*
 * Decompiled with CFR 0.152.
 */
package gui.usermessages;

import activity.ActivityManager;
import gui.GUI;
import gui.usermessages.Message;
import gui.usermessages.MessageList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import network.PacketHandler;

public class SendDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String PREFS_PERIOD = "send_message.period";
    private static final String PREFS_TRANSMISSIONS = "send_message.transmissions";
    private static final String PREFS_V3_MESSAGE_INDEX = "send_message.v3_message_index";
    private static final String PREFS_V4_MESSAGE_INDEX = "send_message.v4_message_index";
    private static final String PREFS_V3_REQUIRE_RESPONSE = "send_message.v3_require_response";
    private static final String PREFS_V4_TO = "send_message.v4_to";
    private static final String PREFS_V4_AVAILABILITY = "send_message.v4_availability";
    private static final String PREFS_V4_DELIVERY = "send_message.v4_delivery";
    private ActivityManager activityManager;
    private MessageList messageList;
    private JComboBox messageNameComboBox;
    private JLabel periodLabel;
    private JTextField periodTextField;
    private JTextField transMissionsTextField;
    private JLabel transmissionsLabel;
    private JLabel requireResponseLabel;
    private JComboBox requireResponseV3ComboBox;
    private JCheckBox requireResponseV4Availability;
    private JCheckBox requireResponseV4Delivery;
    private JLabel toLabelV4;
    private JTextField toFieldV4;
    private JButton send;
    private JButton sendAsV2;
    private JButton sendAsV3;
    private JButton cancel;

    public SendDialog(ActivityManager activityManager, JFrame jFrame) {
        super(jFrame);
        int n;
        this.activityManager = activityManager;
        this.setLayout(new GridBagLayout());
        this.messageList = new MessageList();
        if (this.messageList.hasError()) {
            return;
        }
        if (this.messageList.getSize() == 0) {
            JOptionPane.showMessageDialog(jFrame, "No messages found! Please add one.", "Error", 0);
            this.dispose();
            return;
        }
        JLabel jLabel = new JLabel("Message name: ", 4);
        String[] stringArray = new String[this.messageList.getSize()];
        for (n = 0; n < this.messageList.getSize(); ++n) {
            stringArray[n] = this.messageList.getElementAt(n).toString();
        }
        this.messageNameComboBox = new JComboBox<String>(stringArray);
        n = GUI.getVersion() == GUI.Version.V3 ? GUI.prefs.getInt(PREFS_V3_MESSAGE_INDEX, 0) : GUI.prefs.getInt(PREFS_V4_MESSAGE_INDEX, 0);
        if (stringArray.length > n) {
            this.messageNameComboBox.setSelectedIndex(n);
        }
        int n2 = GUI.prefs.getInt(PREFS_PERIOD, 1000);
        int n3 = GUI.prefs.getInt(PREFS_TRANSMISSIONS, 1);
        this.periodLabel = new JLabel("Period (ms): ", 4);
        this.periodTextField = new JTextField(String.valueOf(n2));
        this.transmissionsLabel = new JLabel("Transmissions: ", 4);
        this.transMissionsTextField = new JTextField(String.valueOf(n3));
        this.requireResponseLabel = new JLabel("Require response: ", 4);
        if (GUI.getVersion() == GUI.Version.V3) {
            int n4 = GUI.prefs.getInt(PREFS_V3_REQUIRE_RESPONSE, 2);
            this.requireResponseV3ComboBox = new JComboBox<String>(new String[]{"Acceptance", "Availability", "Delivery"});
            this.requireResponseV3ComboBox.setSelectedIndex(n4);
        } else {
            String string = GUI.prefs.get(PREFS_V4_TO, "");
            boolean bl = GUI.prefs.getBoolean(PREFS_V4_AVAILABILITY, false);
            boolean bl2 = GUI.prefs.getBoolean(PREFS_V4_DELIVERY, true);
            this.toLabelV4 = new JLabel("To: ", 4);
            this.toFieldV4 = new JTextField(string);
            this.requireResponseV4Availability = new JCheckBox("Availability");
            this.requireResponseV4Availability.setSelected(bl);
            this.requireResponseV4Delivery = new JCheckBox("Delivery");
            this.requireResponseV4Delivery.setSelected(bl2);
        }
        this.send = new JButton("Send");
        this.sendAsV2 = new JButton("Send as OAPV2");
        this.sendAsV3 = new JButton("Send as OAPV3");
        this.cancel = new JButton("Cancel");
        this.send.addActionListener(this);
        this.sendAsV2.addActionListener(this);
        this.sendAsV3.addActionListener(this);
        this.send.setFocusable(true);
        this.cancel.addActionListener(this);
        this.cancel.setActionCommand("close");
        this.add(jLabel, 0, 0);
        this.add(this.messageNameComboBox, 0, 1);
        this.add(this.periodLabel, 1, 0);
        this.add(this.periodTextField, 1, 1);
        this.add(this.transmissionsLabel, 2, 0);
        this.add(this.transMissionsTextField, 2, 1);
        this.add(this.requireResponseLabel, 4, 0);
        if (GUI.getVersion() == GUI.Version.V3) {
            this.add(this.requireResponseV3ComboBox, 4, 1);
        } else {
            this.add(this.toLabelV4, 3, 0);
            this.add(this.toFieldV4, 3, 1);
            this.add(this.requireResponseV4Availability, 4, 1);
            this.add(this.requireResponseV4Delivery, 5, 1);
        }
        this.add(this.send, 6, 0);
        this.add(this.sendAsV2, 6, 1);
        this.add(this.sendAsV3, 6, 2);
        this.add(this.cancel, 6, 3);
        this.getRootPane().setDefaultButton(this.send);
        this.getRootPane().registerKeyboardAction(this, "close", KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setTitle("Send user message");
        this.setResizable(false);
        this.setVisible(true);
    }

    private void add(JComponent jComponent, int n, int n2) {
        this.add(jComponent, n, n2, 1, 1);
    }

    private void add(JComponent jComponent, int n, int n2, int n3, int n4) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n5 = jComponent.getPreferredSize().height;
        jComponent.setPreferredSize(new Dimension(150, n5));
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridheight = n3;
        gridBagConstraints.gridwidth = n4;
        this.add((Component)jComponent, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.send || actionEvent.getSource() == this.sendAsV2 || actionEvent.getSource() == this.sendAsV3) {
            int n = 0;
            int n2 = 0;
            try {
                n = Integer.parseInt(this.periodTextField.getText());
                n2 = Integer.parseInt(this.transMissionsTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Period or Transmissions is not a positive integer!", "Error", 0);
                return;
            }
            if (n < 0 || n2 < 1 || n == 0 && n2 > 1) {
                n = 0;
                n2 = 1;
            }
            String string = this.getTo();
            int n3 = this.getRequireResponse();
            boolean bl = this.getAvailabilityStatus();
            boolean bl2 = this.getDeliveryStatus();
            int n4 = this.messageNameComboBox.getSelectedIndex();
            Message message = this.messageList.getElementAt(n4);
            boolean bl3 = message.isAppendHeader();
            String string2 = message.getXmlData();
            GUI.Version version = GUI.getVersion();
            if (actionEvent.getSource() == this.sendAsV2) {
                version = GUI.Version.VBAD;
            } else if (actionEvent.getSource() == this.sendAsV3) {
                version = GUI.Version.V3;
            }
            PacketHandler.PacketInfo packetInfo = new PacketHandler.PacketInfo(bl3, string2, string, bl, bl2, version);
            this.activityManager.addActivity(n, n2, n3, packetInfo);
            this.saveSettings(n, n2);
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("close")) {
            this.dispose();
        }
    }

    private int getRequireResponse() {
        int n;
        if (GUI.getVersion() == GUI.Version.V3) {
            n = this.requireResponseV3ComboBox.getSelectedIndex() + 1;
            if (n < 1) {
                n = 1;
            }
        } else {
            n = this.requireResponseV4Delivery.isSelected() ? 3 : (this.requireResponseV4Availability.isSelected() ? 2 : 1);
        }
        return n;
    }

    private String getTo() {
        if (GUI.getVersion() == GUI.Version.V3) {
            return null;
        }
        String string = this.toFieldV4.getText().trim();
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    private boolean getAvailabilityStatus() {
        if (GUI.getVersion() == GUI.Version.V3) {
            return false;
        }
        return this.requireResponseV4Availability.isSelected();
    }

    private boolean getDeliveryStatus() {
        if (GUI.getVersion() == GUI.Version.V3) {
            return false;
        }
        return this.requireResponseV4Delivery.isSelected();
    }

    private void saveSettings(int n, int n2) {
        GUI.prefs.putInt(PREFS_PERIOD, n);
        GUI.prefs.putInt(PREFS_TRANSMISSIONS, n2);
        if (GUI.getVersion() == GUI.Version.V3) {
            GUI.prefs.putInt(PREFS_V3_MESSAGE_INDEX, this.messageNameComboBox.getSelectedIndex());
            GUI.prefs.putInt(PREFS_V3_REQUIRE_RESPONSE, this.requireResponseV3ComboBox.getSelectedIndex());
        } else {
            GUI.prefs.putInt(PREFS_V4_MESSAGE_INDEX, this.messageNameComboBox.getSelectedIndex());
            GUI.prefs.putBoolean(PREFS_V4_AVAILABILITY, this.requireResponseV4Availability.isSelected());
            GUI.prefs.putBoolean(PREFS_V4_DELIVERY, this.requireResponseV4Delivery.isSelected());
            GUI.prefs.put(PREFS_V4_TO, this.toFieldV4.getText().trim());
        }
    }
}

