/*
 * Decompiled with CFR 0.152.
 */
package gui.usermessages;

import gui.GUI;
import gui.usermessages.Message;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import utils.XML;

public class MessageList
extends AbstractListModel
implements Iterable<Message> {
    private static final long serialVersionUID = 1L;
    private static final String filename = "messages.xml";
    private static final String schemaFilename = "messages.xsd";
    private ArrayList<Message> messageList;
    private ArrayList<Message> filterList;
    private Filter filter = GUI.getVersion() == GUI.Version.V3 ? Filter.V3 : Filter.V4;
    private boolean hasError;

    public MessageList() {
        this.filterList = new ArrayList();
        File file = new File(filename);
        if (file.exists() && file.canRead()) {
            this.readFromFile(filename);
            this.updateFilter();
        } else {
            this.messageList = new ArrayList();
        }
    }

    private void readFromFile(String string) {
        Object object;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", new File(schemaFilename));
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(parserConfigurationException.getMessage());
            this.hasError = true;
            return;
        }
        MyErrorHandler myErrorHandler = new MyErrorHandler();
        documentBuilder.setErrorHandler(myErrorHandler);
        this.messageList = new ArrayList();
        try {
            Document document = documentBuilder.parse(string);
            object = document.getElementsByTagName("message");
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                String string2 = XML.getElementValue(node, "name").trim();
                boolean bl = Boolean.valueOf(XML.getElementValue(node, "appendHeader"));
                GUI.Version version = GUI.Version.getVersion(Integer.valueOf(XML.getElementValue(node, "version").trim()));
                String string3 = XML.getElementValue(node, "xmlData");
                this.messageList.add(new Message(string2, version, bl, string3));
            }
            Collections.sort(this.messageList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = myErrorHandler.getErrors();
        if (!((String)object).isEmpty()) {
            this.hasError = true;
            String string4 = "Please fix the XML error in file " + string + ":\n";
            string4 = string4 + (String)object;
            JOptionPane.showMessageDialog(null, string4, "XML errors", 0);
        }
    }

    private void updateFilter() {
        this.filterList.clear();
        for (Message message : this.messageList) {
            if ((this.filter != Filter.V3 || message.getVersion() != GUI.Version.V3) && (this.filter != Filter.V4 || message.getVersion() != GUI.Version.V4)) continue;
            this.filterList.add(message);
        }
        this.fireContentsChanged(this, 0, this.filterList.size() - 1);
    }

    public boolean hasError() {
        return this.hasError;
    }

    public void viewV3Only() {
        this.filter = Filter.V3;
        this.updateFilter();
    }

    public void viewV4Only() {
        this.filter = Filter.V4;
        this.updateFilter();
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messageList.iterator();
    }

    @Override
    public Message getElementAt(int n) {
        return this.filterList.get(n);
    }

    @Override
    public int getSize() {
        return this.filterList.size();
    }

    public Message remove(int n) {
        Message message = this.filterList.remove(n);
        this.messageList.remove(message);
        this.updateFilter();
        return message;
    }

    public void add(Message message) {
        this.messageList.add(message);
        this.updateFilter();
    }

    public void messageUpdated() {
        this.updateFilter();
    }

    private String toXml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        stringBuilder.append("<messages xmlns=\"oaptest-messages\" ");
        stringBuilder.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n");
        for (Message message : this.messageList) {
            message.getXml(stringBuilder, "\t");
        }
        stringBuilder.append("</messages>\r\n");
        return stringBuilder.toString();
    }

    public void saveToFile() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            bufferedWriter.write(this.toXml());
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException.getMessage(), "Error", 0);
        }
    }

    private class MyErrorHandler
    implements ErrorHandler {
        private StringBuilder errors = new StringBuilder();

        @Override
        public void error(SAXParseException sAXParseException) throws SAXParseException {
            this.appendError("Error", sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            this.appendError("Fatal error", sAXParseException);
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXParseException {
            this.appendError("Warning", sAXParseException);
        }

        private void appendError(String string, SAXParseException sAXParseException) {
            this.errors.append("- " + string + ":\n");
            this.errors.append("  " + sAXParseException.getMessage() + "\n");
            this.errors.append("  Line: " + sAXParseException.getLineNumber());
            this.errors.append(", column: " + sAXParseException.getColumnNumber() + ".\n");
        }

        public String getErrors() {
            return this.errors.toString();
        }
    }

    private static enum Filter {
        V3,
        V4;

    }
}

