/*
 * Decompiled with CFR 0.152.
 */
package gui.usermessages;

import gui.GUI;
import gui.MyGridBagConstraints;
import gui.usermessages.Message;
import gui.usermessages.MessageList;
import gui.usermessages.ViewAllDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class EditDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private MessageList messageList;
    private Message message;
    private JTextField nameField;
    private JComboBox versionComboBox;
    private JTextArea xmlArea;
    private JCheckBox appendHeaderBox;
    private JButton okButton;
    private JButton cancelButton;

    public EditDialog(MessageList messageList, Message message, ViewAllDialog viewAllDialog) {
        super(viewAllDialog);
        this.messageList = messageList;
        this.message = message;
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Name:");
        this.nameField = new JTextField(message.getName());
        jLabel.setPreferredSize(new Dimension(94, 20));
        this.nameField.setPreferredSize(new Dimension(300, 20));
        JLabel jLabel2 = new JLabel("Version:");
        this.versionComboBox = new JComboBox<String>(new String[]{"3", "4"});
        if (message.getVersion() == GUI.Version.V3) {
            this.versionComboBox.setSelectedIndex(0);
        } else {
            this.versionComboBox.setSelectedIndex(1);
        }
        jLabel2.setPreferredSize(new Dimension(94, 20));
        this.versionComboBox.setPreferredSize(new Dimension(300, 20));
        this.xmlArea = new JTextArea(message.getXmlData());
        JScrollPane jScrollPane = new JScrollPane(this.xmlArea, 22, 32);
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        this.appendHeaderBox = new JCheckBox("Append OAP header");
        this.appendHeaderBox.setPreferredSize(new Dimension(300, 20));
        this.appendHeaderBox.setSelected(message.isAppendHeader());
        this.okButton = new JButton("Ok");
        this.cancelButton = new JButton("Cancel");
        this.okButton.setPreferredSize(new Dimension(67, 23));
        this.cancelButton.setPreferredSize(new Dimension(67, 23));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("close");
        this.add((Component)jLabel, new MyGridBagConstraints(0, 0));
        this.add((Component)this.nameField, new MyGridBagConstraints(0, 1));
        this.add((Component)jLabel2, new MyGridBagConstraints(1, 0));
        this.add((Component)this.versionComboBox, new MyGridBagConstraints(1, 1));
        this.add((Component)this.appendHeaderBox, new MyGridBagConstraints(2, 1));
        this.add((Component)jScrollPane, new MyGridBagConstraints(3, 0, 1, 2));
        this.add((Component)this.okButton, new MyGridBagConstraints(0, 2));
        this.add((Component)this.cancelButton, new MyGridBagConstraints(1, 2));
        this.getRootPane().setDefaultButton(this.okButton);
        this.getRootPane().registerKeyboardAction(this, "close", KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setLocationRelativeTo(viewAllDialog);
        this.setTitle("Edit user message");
        this.setModal(true);
        this.setResizable(false);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            String string = this.nameField.getText().trim();
            if (string.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Please enter name correctly", "Error", 0);
                return;
            }
            GUI.Version version = this.versionComboBox.getSelectedIndex() == 0 ? GUI.Version.V3 : GUI.Version.V4;
            String string2 = this.xmlArea.getText();
            if (string2.indexOf("]]>") > 0) {
                JOptionPane.showMessageDialog(this, "The string ]]> is not allowed in the XML data.", "Error", 0);
                return;
            }
            this.message.setName(string);
            this.message.setAppendHeader(this.appendHeaderBox.isSelected());
            this.message.setVersion(version);
            this.message.setXmlData(string2);
            this.messageList.messageUpdated();
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("close")) {
            this.dispose();
        }
    }
}

