/*
 * Decompiled with CFR 0.152.
 */
package gui.tab;

import gui.tab.Request;
import utils.XML;

public class Response {
    public static final int TYPE_ACCEPTANCE = 1;
    public static final int TYPE_AVAILABILITY = 2;
    public static final int TYPE_DELIVERY = 3;
    public static final int TYPE_MANUAL_ACKNOWLEDGE = 4;
    public static final int TYPE_INTERACTION_RESPONSE = 5;
    private Request request;
    private int type;
    private int code;
    private String xml;
    private boolean error;

    public Response(int n, int n2, String string, boolean bl) {
        this.type = n;
        this.code = n2;
        this.xml = string;
        this.error = bl;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }

    public String getXml(boolean bl) {
        String string = XML.prettyPrint(this.xml, null);
        if (bl || string == null) {
            return this.xml;
        }
        return string;
    }

    public String getStatus() {
        switch (this.type) {
            case 1: {
                return "Acceptance";
            }
            case 2: {
                return "Availability";
            }
            case 3: {
                return "Delivery";
            }
            case 4: {
                return "Manual acknowledge";
            }
            case 5: {
                return "Interaction response";
            }
        }
        return "<Unknown>";
    }

    public boolean hasError() {
        if (this.type == 2) {
            return this.error;
        }
        return this.error || this.code != 200;
    }

    public int getCode() {
        return this.code;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return "Status: " + this.getStatus() + ", Code: " + (this.code == -1 ? "-" : Integer.valueOf(this.code));
    }

    public void setHasError(boolean bl) {
        this.error = bl;
    }
}

