/*
 * Decompiled with CFR 0.152.
 */
package gui.tab;

import gui.tab.OverviewTable;
import gui.tab.Request;
import gui.tab.Response;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;

public class OverviewTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private final int MAX_ROWS = 1000;
    private static final int CLEAN_UP_ROWS = 50;
    private String[] columnNames;
    private ArrayList<Request> data;
    private HashMap<String, Request> dataMapOut;
    private HashMap<String, Request> dataMapIn;
    private OverviewTable table;

    public OverviewTableModel(OverviewTable overviewTable) {
        this.table = overviewTable;
        this.columnNames = new String[]{"Time", "Direction", "Activity id", "Service", "Id"};
        this.data = new ArrayList();
        this.dataMapOut = new HashMap();
        this.dataMapIn = new HashMap();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.data.get(n).getData(n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.data.get(n).setData(n2, object);
        this.fireTableCellUpdated(n, n2);
    }

    public void addRequest(Request request) {
        if (this.data.size() >= 1050) {
            this.removeOldRows(50);
        }
        if (!request.getId().equals("<Unknown>")) {
            this.getDataTable(request.getDirection()).put(request.getId(), request);
        }
        this.data.add(request);
        int n = this.data.size() - 1;
        this.fireTableRowsInserted(n, n);
    }

    public void addResponse(Request.Direction direction, String string, Response response) {
        Request request = this.getDataTable(direction).get(string);
        if (request != null) {
            request.addResponse(response);
            response.setRequest(request);
            if (response.hasError()) {
                request.setHasError(true);
                for (int i = this.data.size() - 1; i >= 0; --i) {
                    if (!this.data.get(i).getId().equals(string)) continue;
                    this.fireTableRowsUpdated(i, i);
                    break;
                }
            }
        }
    }

    public Request getRequest(int n) {
        return this.data.get(n);
    }

    public void clear() {
        this.data = new ArrayList();
        this.dataMapOut = new HashMap();
        this.dataMapIn = new HashMap();
        this.fireTableDataChanged();
    }

    private void removeOldRows(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Request request = this.data.remove(0);
            this.getDataTable(request.getDirection()).remove(request.getId());
            if (request.getDirection() == Request.Direction.OUT) {
                ++n2;
                continue;
            }
            ++n3;
        }
        this.table.rowsRemovedFromView(n2, n3);
    }

    private HashMap<String, Request> getDataTable(Request.Direction direction) {
        if (direction == Request.Direction.OUT) {
            return this.dataMapOut;
        }
        return this.dataMapIn;
    }

    public void setError(Request.Direction direction, String string) {
        Request request = this.getDataTable(direction).get(string);
        if (request != null) {
            request.setHasError(true);
            for (int i = this.data.size() - 1; i >= 0; --i) {
                if (!this.data.get(i).getId().equals(string)) continue;
                this.fireTableRowsUpdated(i, i);
                break;
            }
        }
    }
}

