/*
 * Decompiled with CFR 0.152.
 */
package gui.tab;

import gui.tab.OverviewTab;
import gui.tab.OverviewTableModel;
import gui.tab.Request;
import gui.tab.Response;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public class OverviewTable {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private OverviewTableModel model;
    private OverviewTab overviewPane;
    private JScrollPane scrollPane;
    private TableRowSorter<OverviewTableModel> sorter;
    private RowFilter<OverviewTableModel, Integer> filterViewOutOnly;
    private RowFilter<OverviewTableModel, Integer> filterViewInOnly;
    private DefaultTableCellRenderer cellRenderer;

    public OverviewTable(OverviewTab overviewTab) {
        this.overviewPane = overviewTab;
        this.model = new OverviewTableModel(this);
        this.sorter = new TableRowSorter<OverviewTableModel>(this.model);
        this.sorter.setSortable(0, false);
        this.sorter.setSortable(1, false);
        this.sorter.setSortable(2, false);
        this.sorter.setSortable(3, false);
        this.sorter.setSortable(4, false);
        this.initCellRenderer();
        this.table = new JTable(this.model){
            private static final long serialVersionUID = 1L;

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return OverviewTable.this.cellRenderer;
            }
        };
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        this.table.setRowSorter(this.sorter);
        this.table.setGridColor(Color.LIGHT_GRAY);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(113, 0);
        InputMap inputMap = this.table.getInputMap(1).getParent();
        inputMap.remove(keyStroke);
        this.scrollPane = new JScrollPane(this.table, 22, 31);
        this.initSelectionListener();
        this.initRowFilters();
    }

    private void initSelectionListener() {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ((OverviewTable)OverviewTable.this).overviewPane.dataList.clearSelection();
                OverviewTable.this.overviewPane.updateXmlArea();
            }
        });
    }

    private void initCellRenderer() {
        this.cellRenderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;
            private final Color blueColor = new Color(10, 36, 106);

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Request request = OverviewTable.this.model.getRequest(jTable.convertRowIndexToModel(n));
                this.setValue(object);
                if (bl) {
                    this.setBackground(this.blueColor);
                } else {
                    this.setBackground(Color.white);
                }
                if (request.hasError()) {
                    this.setForeground(Color.red);
                } else if (bl) {
                    this.setForeground(Color.white);
                } else {
                    this.setForeground(Color.black);
                }
                return this;
            }
        };
    }

    private void initRowFilters() {
        this.filterViewOutOnly = new RowFilter<OverviewTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends OverviewTableModel, ? extends Integer> entry) {
                OverviewTableModel overviewTableModel = entry.getModel();
                Request.Direction direction = overviewTableModel.getRequest(entry.getIdentifier()).getDirection();
                return direction == Request.Direction.OUT;
            }
        };
        this.filterViewInOnly = new RowFilter<OverviewTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends OverviewTableModel, ? extends Integer> entry) {
                OverviewTableModel overviewTableModel = entry.getModel();
                Request.Direction direction = overviewTableModel.getRequest(entry.getIdentifier()).getDirection();
                return direction == Request.Direction.IN;
            }
        };
    }

    protected JScrollPane getTable() {
        return this.scrollPane;
    }

    protected void viewOutOnly() {
        this.sorter.setRowFilter(this.filterViewOutOnly);
        this.table.getSelectionModel().clearSelection();
    }

    protected void viewInOnly() {
        this.sorter.setRowFilter(this.filterViewInOnly);
        this.table.getSelectionModel().clearSelection();
    }

    protected void viewAll() {
        this.sorter.setRowFilter(null);
        this.table.getSelectionModel().clearSelection();
    }

    protected void addRequest(Request request) {
        this.model.addRequest(request);
        if (this.overviewPane.autoScroll()) {
            this.scrollToRow(this.table.getRowCount() - 1);
        }
    }

    protected void addResponse(Request.Direction direction, String string, Response response) {
        int n;
        Request request;
        this.model.addResponse(direction, string, response);
        int n2 = this.table.getSelectedRow();
        if (n2 >= 0 && (request = this.model.getRequest(n = this.table.convertRowIndexToModel(n2))).getId().equals(string)) {
            this.overviewPane.addRequestToList(request);
        }
    }

    protected Request getRequest(int n) {
        int n2 = this.table.convertRowIndexToModel(n);
        return this.model.getRequest(n2);
    }

    protected void clearModel() {
        this.model.clear();
    }

    protected void scrollToRow(int n) {
        JViewport jViewport = (JViewport)this.table.getParent();
        Rectangle rectangle = this.table.getCellRect(n, 0, true);
        Point point = jViewport.getViewPosition();
        rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
        jViewport.scrollRectToVisible(rectangle);
    }

    protected void rowsRemovedFromView(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = n + n2;
        int n6 = this.overviewPane.getViewDirection();
        switch (n6) {
            case 0: {
                n4 = n + n2;
                break;
            }
            case 1: {
                n4 = n;
                break;
            }
            case 2: {
                n4 = n2;
            }
        }
        int n7 = this.table.getSelectedRow();
        int n8 = this.overviewPane.dataList.getSelectedIndex();
        this.model.fireTableRowsDeleted(0, n5 - 1);
        if (n7 >= 0 && (n3 = n7 - n4) >= 0) {
            this.table.getSelectionModel().setSelectionInterval(n3, n3);
        }
        if (n8 >= 0) {
            this.overviewPane.dataList.setSelectedIndex(n8);
        }
        JViewport jViewport = (JViewport)this.table.getParent();
        Point point = jViewport.getViewPosition();
        point.translate(0, -this.table.getRowHeight() * n4);
        if (point.y < 0) {
            point.y = 0;
        }
        jViewport.setViewPosition(point);
    }

    protected int getSelectedIndex() {
        return this.table.getSelectedRow();
    }

    public void addSendError(Request.Direction direction, String string) {
        this.model.setError(direction, string);
    }
}

