/*
 * Decompiled with CFR 0.152.
 */
package gui.tab;

import gui.GUI;
import gui.tab.Log;
import gui.tab.OverviewTable;
import gui.tab.Request;
import gui.tab.Response;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import network.PacketHandler;

public class OverviewTab
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private PacketHandler packetHandler;
    private static final long serialVersionUID = 1L;
    public static final int TABLE_VIEW_ALL = 0;
    public static final int TABLE_VIEW_OUT = 1;
    public static final int TABLE_VIEW_IN = 2;
    public static final String PREFS_VIEW_DETAILS = "overview.view_details_window";
    public static final String PREFS_VIEW_LOG = "overview.view_log_window";
    public static final String PREFS_VIEW_RAW_XML = "overview.view_raw_xml";
    private int requests = 0;
    private int responses = 0;
    private JLabel requestLabel;
    private JLabel responseLabel;
    private JCheckBox autoScroll;
    private JComboBox viewDirectionCombo;
    private JPanel tablePanel;
    private OverviewTable table;
    private JPanel detailPanel;
    protected JList dataList;
    private DefaultListModel listModel;
    private Request selectedRequest;
    private JTextArea xmlArea;
    private JCheckBox viewRawXmlBox;
    JTextPane logTextPane;
    private JScrollPane logScrollPane;
    public Log log;
    private JSplitPane tableDetailSplitPane;
    private JSplitPane centerLogSplitPane;
    private JLabel acceptInputLabel;
    private JFormattedTextField acceptInputField;
    private JLabel availInputLabel;
    private JFormattedTextField availInputField;
    private JLabel delivInputLabel;
    private JFormattedTextField delivInputField;

    public OverviewTab(GUI gUI, PacketHandler packetHandler) {
        this.packetHandler = packetHandler;
        this.setLayout(new BorderLayout());
        this.createUpperPanel();
        this.createTablePanel();
        this.createRightPanel();
        this.createLogPanel();
        this.createSplitPanes();
    }

    private void createUPInputFields(JPanel jPanel) {
        this.acceptInputLabel = new JLabel("Accept code (0==>disable):");
        this.acceptInputField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.acceptInputField.setValue(new Integer(200));
        this.acceptInputField.setColumns(3);
        jPanel.add(this.acceptInputLabel);
        jPanel.add(this.acceptInputField);
        this.acceptInputField.addPropertyChangeListener("value", this);
        this.availInputLabel = new JLabel("Availability code:");
        this.availInputField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.availInputField.setValue(new Integer(200));
        this.availInputField.setColumns(3);
        jPanel.add(this.availInputLabel);
        jPanel.add(this.availInputField);
        this.availInputField.addPropertyChangeListener("value", this);
        this.delivInputLabel = new JLabel("Delivery code:");
        this.delivInputField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.delivInputField.setValue(new Integer(200));
        this.delivInputField.setColumns(3);
        jPanel.add(this.delivInputLabel);
        jPanel.add(this.delivInputField);
        this.delivInputField.addPropertyChangeListener("value", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object == this.acceptInputField) {
            int n = ((Number)this.acceptInputField.getValue()).intValue();
            this.packetHandler.SetAcceptRespCode(n);
            this.acceptInputField.setValue(new Integer(n));
        } else if (object == this.availInputField) {
            int n = ((Number)this.availInputField.getValue()).intValue();
            this.packetHandler.SetAvailRespCode(n);
            this.availInputField.setValue(new Integer(n));
        } else if (object == this.delivInputField) {
            int n = ((Number)this.delivInputField.getValue()).intValue();
            this.packetHandler.SetDelivRespCode(n);
            this.delivInputField.setValue(new Integer(n));
        }
    }

    private void createUpperPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 12, 5));
        this.requestLabel = new JLabel("Total requests: " + this.requests);
        this.responseLabel = new JLabel("Total responses: " + this.requests);
        jPanel.add(this.requestLabel);
        jPanel.add(this.responseLabel);
        this.createUPInputFields(jPanel);
        this.add((Component)jPanel, "North");
    }

    private void createTablePanel() {
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.autoScroll = new JCheckBox("Autoscroll");
        this.autoScroll.setSelected(true);
        this.viewDirectionCombo = new JComboBox<String>(new String[]{"View all", "View OUT only", "View IN only"});
        this.viewDirectionCombo.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout(0, 12, 5));
        jPanel.add(this.autoScroll);
        jPanel.add(this.viewDirectionCombo);
        this.table = new OverviewTable(this);
        this.tablePanel.add((Component)jPanel, "North");
        this.tablePanel.add((Component)this.table.getTable(), "Center");
    }

    private void createRightPanel() {
        this.detailPanel = new JPanel();
        this.listModel = new DefaultListModel();
        this.dataList = new JList(this.listModel);
        this.dataList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (OverviewTab.this.dataList.getSelectedIndex() >= 0) {
                    OverviewTab.this.updateXmlArea();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.dataList);
        jScrollPane.setPreferredSize(new Dimension(370, 150));
        this.xmlArea = new JTextArea(10, 0);
        this.xmlArea.getInputMap().put(KeyStroke.getKeyStroke("ctrl DELETE"), "none");
        this.xmlArea.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.xmlArea, 22, 32);
        jScrollPane2.setPreferredSize(new Dimension(370, 0));
        boolean bl = GUI.prefs.getBoolean(PREFS_VIEW_RAW_XML, false);
        this.viewRawXmlBox = new JCheckBox("View raw XML");
        this.viewRawXmlBox.setSelected(bl);
        this.viewRawXmlBox.addActionListener(this);
        this.detailPanel.setLayout(new BorderLayout());
        this.detailPanel.add((Component)jScrollPane, "North");
        this.detailPanel.add((Component)jScrollPane2, "Center");
        this.detailPanel.add((Component)this.viewRawXmlBox, "South");
        this.detailPanel.setVisible(GUI.prefs.getBoolean(PREFS_VIEW_DETAILS, true));
    }

    private void createLogPanel() {
        this.logTextPane = new JTextPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSize(Dimension dimension) {
                if (dimension.width < this.getParent().getSize().width) {
                    dimension.width = this.getParent().getSize().width;
                }
                super.setSize(dimension);
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        this.log = new Log(this.logTextPane, this.logTextPane.getStyledDocument());
        this.logTextPane.getInputMap().put(KeyStroke.getKeyStroke("ctrl DELETE"), "none");
        this.logTextPane.setEditable(false);
        this.logTextPane.setFont(new Font("monospaced", 0, 12));
        this.logScrollPane = new JScrollPane(this.logTextPane, 22, 30);
        this.logScrollPane.setBorder(BorderFactory.createTitledBorder("Log"));
        this.logScrollPane.setPreferredSize(new Dimension(0, 250));
        this.logScrollPane.setMinimumSize(new Dimension(0, 250));
        this.logScrollPane.setVisible(GUI.prefs.getBoolean(PREFS_VIEW_LOG, true));
    }

    private void createSplitPanes() {
        this.tableDetailSplitPane = new JSplitPane(1, this.tablePanel, this.detailPanel);
        this.tableDetailSplitPane.setBorder(BorderFactory.createTitledBorder("Last requests (1000)"));
        this.tableDetailSplitPane.setResizeWeight(1.0);
        this.centerLogSplitPane = new JSplitPane(0, this.tableDetailSplitPane, this.logScrollPane);
        this.centerLogSplitPane.setBorder(null);
        this.centerLogSplitPane.setResizeWeight(1.0);
        this.add((Component)this.centerLogSplitPane, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.viewDirectionCombo) {
            int n = this.dataList.getSelectedIndex();
            switch (this.viewDirectionCombo.getSelectedIndex()) {
                case 0: {
                    this.table.viewAll();
                    break;
                }
                case 1: {
                    this.table.viewOutOnly();
                    break;
                }
                case 2: {
                    this.table.viewInOnly();
                }
            }
            if (n >= 0) {
                this.dataList.setSelectedIndex(n);
            }
        } else if (actionEvent.getSource() == this.viewRawXmlBox) {
            this.updateXmlArea();
            GUI.prefs.putBoolean(PREFS_VIEW_RAW_XML, this.viewRawXmlBox.isSelected());
        }
    }

    protected int getViewDirection() {
        return this.viewDirectionCombo.getSelectedIndex();
    }

    protected void setXmlArea(String string) {
        this.xmlArea.setText(string);
        this.xmlArea.setCaretPosition(0);
    }

    public void clearAll() {
        this.requests = 0;
        this.responses = 0;
        this.requestLabel.setText("Total requests: 0");
        this.responseLabel.setText("Total responses: 0");
        this.table.clearModel();
        this.listModel.clear();
        this.xmlArea.setText("");
        this.logTextPane.setText("");
    }

    protected boolean autoScroll() {
        return this.autoScroll.isSelected();
    }

    protected void addRequestToList(Request request) {
        this.listModel.clear();
        this.listModel.addElement("[1] Request (id: " + request.getId() + ")");
        this.listModel.addElement("---------------------------------------");
        int n = 2;
        for (Response response : request.getResponses()) {
            this.listModel.addElement("[" + n + "] Response, " + response.toString());
            ++n;
        }
        this.selectedRequest = request;
    }

    public void viewLogWindow() {
        this.logScrollPane.setVisible(true);
        this.centerLogSplitPane.resetToPreferredSizes();
        GUI.prefs.putBoolean(PREFS_VIEW_LOG, true);
    }

    public void hideLogWindow() {
        this.logScrollPane.setVisible(false);
        GUI.prefs.putBoolean(PREFS_VIEW_LOG, false);
    }

    public void viewDetailWindow() {
        this.detailPanel.setVisible(true);
        this.tableDetailSplitPane.resetToPreferredSizes();
        GUI.prefs.putBoolean(PREFS_VIEW_DETAILS, true);
    }

    public void hideDetailWindow() {
        this.detailPanel.setVisible(false);
        GUI.prefs.putBoolean(PREFS_VIEW_DETAILS, false);
    }

    protected boolean viewRawXml() {
        return this.viewRawXmlBox.isSelected();
    }

    public void addRequest(Request request) {
        this.table.addRequest(request);
        ++this.requests;
        this.requestLabel.setText("Total requests: " + this.requests);
        String string = request.getDirection() == Request.Direction.OUT ? "Sending '" + request.getService() + "', " : "'" + request.getService() + "' received, ";
        string = string + "Id: " + request.getId();
        this.log.appendMessage(string);
    }

    public void addResponse(Request.Direction direction, String string, Response response) {
        this.table.addResponse(direction, string, response);
        ++this.responses;
        this.responseLabel.setText("Total responses: " + this.responses);
        String string2 = direction == Request.Direction.OUT ? "Response received, " : "Sending response, ";
        string2 = string2 + response.toString() + ", ";
        string2 = string2 + "Id: " + string;
        if (response.hasError()) {
            this.log.appendErrorMessage(string2);
        } else {
            this.log.appendMessage(string2);
        }
    }

    protected void updateXmlArea() {
        int n = this.table.getSelectedIndex();
        int n2 = this.dataList.getSelectedIndex();
        boolean bl = this.viewRawXmlBox.isSelected();
        if (n2 >= 0) {
            if (n2 == 0) {
                this.setXmlArea(this.selectedRequest.getXml(bl));
            } else if (n2 == 1) {
                this.setXmlArea("");
            } else if (n2 >= 2) {
                String string = this.selectedRequest.getResponses().get(n2 - 2).getXml(bl);
                this.setXmlArea(string);
            }
        } else if (n >= 0) {
            Request request = this.table.getRequest(n);
            this.setXmlArea(request.getXml(this.viewRawXml()));
            this.addRequestToList(request);
        }
    }

    public void addSendError(Request.Direction direction, String string) {
        this.table.addSendError(direction, string);
    }
}

