/*
 * Decompiled with CFR 0.152.
 */
package gui.tab;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import utils.DateUtils;

public class Log {
    private final JTextPane textPane;
    private StyledDocument doc;
    private SimpleAttributeSet normalStyle;
    private SimpleAttributeSet systemStyle;
    private SimpleAttributeSet errorStyle;
    private boolean fileLogActive;
    private String filename;
    private FileWriter fileWriter;

    public Log(JTextPane jTextPane, StyledDocument styledDocument) {
        this.textPane = jTextPane;
        this.doc = styledDocument;
        this.normalStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.normalStyle, Color.black);
        this.systemStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.systemStyle, Color.blue);
        this.errorStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errorStyle, Color.red);
        this.fileLogActive = false;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public void logToFile(boolean bl) {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileWriter = null;
        }
        if (bl && this.filename != null) {
            try {
                this.fileWriter = new FileWriter(this.filename, true);
                this.fileLogActive = true;
            }
            catch (IOException iOException) {
                this.fileLogActive = false;
                this.appendErrorMessage("Failed to open log file: " + iOException.getMessage());
            }
        } else {
            this.fileLogActive = false;
        }
    }

    public boolean getLogToFile() {
        return this.fileLogActive;
    }

    public void appendMessage(String string) {
        this.appendMessage(string, this.normalStyle, "normal");
    }

    public void appendSystemMessage(String string) {
        this.appendMessage(string, this.systemStyle, "system");
    }

    public void appendErrorMessage(String string) {
        this.appendMessage(string, this.errorStyle, "error ");
    }

    private void appendMessage(String string, SimpleAttributeSet simpleAttributeSet, String string2) {
        try {
            String string3;
            if (this.doc.getLength() > 80000) {
                string3 = this.doc.getText(10000, 1000);
                int n = 10000 + string3.indexOf(10) + 1;
                this.doc.remove(0, n);
            }
            if (this.doc.getLength() > 0) {
                this.doc.insertString(this.doc.getLength(), "\n", this.normalStyle);
            }
            string3 = DateUtils.getDateAndTime() + "   " + string;
            if (this.fileLogActive) {
                try {
                    this.fileWriter.write("[" + string2 + "] " + string3 + "\r\n");
                    this.fileWriter.flush();
                }
                catch (IOException iOException) {
                    try {
                        this.fileWriter.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    this.fileLogActive = false;
                    this.fileWriter = null;
                    this.appendErrorMessage("Failed to write to log file: " + iOException.getMessage());
                }
            }
            this.doc.insertString(this.doc.getLength(), string3, simpleAttributeSet);
            this.textPane.setCaretPosition(this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }
}

