/*
 * Decompiled with CFR 0.152.
 */
package gui.tab;

import activity.ActivityData;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class ActivityTableModel
extends AbstractTableModel {
    protected static final int COLUMN_ID = 0;
    protected static final int COLUMN_ACTIVE = 1;
    protected static final int COLUMN_SERVICE = 2;
    protected static final int COLUMN_TRANSMISSIONS = 3;
    protected static final int COLUMN_PERIOD = 4;
    protected static final int COLUMN_SENT = 5;
    protected static final int COLUMN_TCP_IP_ERRORS = 6;
    protected static final int COLUMN_SUCCESS = 7;
    protected static final int COLUMN_CONGESTIONS = 8;
    protected static final int COLUMN_FAILURES = 9;
    protected static final int COLUMN_PENDING = 10;
    protected static final int COLUMN_MAX_PENDING = 11;
    private static final long serialVersionUID = 198868000620195056L;
    private ArrayList<ActivityData> rows;
    private String[] columnNames = new String[]{"Id", "Active", "Service", "Transmissions", "Period (ms)", "Sent", "TCP/IP errors", "Success", "Congestions", "Failures", "Pending", "Max pending"};

    public ActivityTableModel() {
        this.rows = new ArrayList();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ActivityData activityData = this.rows.get(n);
        switch (n2) {
            case 1: {
                if (activityData.isActive()) {
                    return "Yes";
                }
                return "No";
            }
            case 0: {
                return "#" + activityData.getActivityId();
            }
            case 2: {
                String string = activityData.getService();
                if (string == null) {
                    return "<Unknown>";
                }
                return string;
            }
            case 3: {
                int n3 = activityData.getTransmissions();
                if (n3 == 0) {
                    return "-";
                }
                return new Integer(n3);
            }
            case 4: {
                return activityData.getPeriod();
            }
            case 5: {
                return activityData.getPacketsSent();
            }
            case 6: {
                return activityData.getTcpIpErrors();
            }
            case 7: {
                return activityData.getPacketsSuccess();
            }
            case 8: {
                return activityData.getPacketsCongestion();
            }
            case 9: {
                return activityData.getPacketsFailure();
            }
            case 10: {
                return activityData.getPacketsPending();
            }
            case 11: {
                return activityData.getPacketsMaxPending();
            }
        }
        return null;
    }

    public void addActivity(ActivityData activityData) {
        this.rows.add(activityData);
        int n = this.rows.size() - 1;
        this.fireTableRowsInserted(n, n);
    }

    public void removeActivity(int n) {
        int n2 = this.getRow(n);
        if (n2 >= 0) {
            this.rows.remove(n2);
            this.fireTableRowsDeleted(n2, n2);
        }
    }

    protected ActivityData getActivity(int n) {
        return this.rows.get(n);
    }

    public void activityUpdated(ActivityData activityData) {
        int n = this.getRow(activityData.getActivityId());
        if (n >= 0) {
            this.fireTableRowsUpdated(n, n);
        }
    }

    protected int getRow(int n) {
        for (int i = 0; i < this.rows.size(); ++i) {
            ActivityData activityData = this.rows.get(i);
            if (activityData.getActivityId() != n) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.rows = new ArrayList();
        this.fireTableDataChanged();
    }
}

