/*
 * Decompiled with CFR 0.152.
 */
package gui.tab;

import activity.ActivityData;
import activity.ActivityManager;
import gui.tab.ActivityTab;
import gui.tab.ActivityTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class ActivityTable
implements ActionListener {
    private final ActivityTableModel model;
    private final ActivityTab activityPane;
    private final ActivityManager activityManager;
    private JTable table;
    private JScrollPane scrollPane;
    private JPopupMenu popup;
    private JMenuItem menuStop;
    private JMenuItem menuRemove;

    public ActivityTable(ActivityTab activityTab, ActivityTableModel activityTableModel, ActivityManager activityManager) {
        this.activityPane = activityTab;
        this.model = activityTableModel;
        this.activityManager = activityManager;
        this.table = new JTable(activityTableModel);
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        this.table.setGridColor(Color.LIGHT_GRAY);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.scrollPane = new JScrollPane(this.table, 22, 31);
        this.initSelectionListener();
        this.initKeyListener();
        this.initPopupMenu();
        this.initCellRenderer();
    }

    private void initSelectionListener() {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = ActivityTable.this.table.getSelectedRow();
                if (n >= 0) {
                    ActivityData activityData = ActivityTable.this.model.getActivity(n);
                    ActivityTable.this.activityPane.setXmlText(activityData.getXmlPreview());
                }
            }
        });
    }

    private void initKeyListener() {
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    ActivityTable.this.removeSelectedActivity();
                }
            }
        });
    }

    private void initCellRenderer() {
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;
            private final Color LIGHT_BLUE = new Color(67, 110, 238);
            private final Color LIGHT_GREY = new Color(170, 170, 170);

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Color color;
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                ActivityData activityData = ActivityTable.this.model.getActivity(n);
                switch (n2) {
                    case 10: {
                        int n3 = (Integer)object;
                        if (n3 > 0) {
                            if (bl) {
                                color = this.LIGHT_BLUE;
                                break;
                            }
                            color = Color.BLUE;
                            break;
                        }
                        color = this.getDefaultColor(bl, activityData.isActive());
                        break;
                    }
                    case 6: 
                    case 8: 
                    case 9: {
                        int n4 = (Integer)object;
                        if (n4 > 0) {
                            color = Color.RED;
                            break;
                        }
                        color = this.getDefaultColor(bl, activityData.isActive());
                        break;
                    }
                    default: {
                        color = this.getDefaultColor(bl, activityData.isActive());
                    }
                }
                this.setForeground(color);
                return this;
            }

            private Color getDefaultColor(boolean bl, boolean bl2) {
                if (bl2) {
                    if (bl) {
                        return Color.WHITE;
                    }
                    return Color.BLACK;
                }
                return this.LIGHT_GREY;
            }
        });
    }

    private void initPopupMenu() {
        this.popup = new JPopupMenu();
        this.menuStop = new JMenuItem("Stop");
        this.menuRemove = new JMenuItem("Remove");
        this.menuStop.addActionListener(this);
        this.menuRemove.addActionListener(this);
        this.popup.add(this.menuStop);
        this.popup.add(this.menuRemove);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = ActivityTable.this.table.rowAtPoint(mouseEvent.getPoint());
                if (n < 0) {
                    ActivityTable.this.table.clearSelection();
                    ActivityTable.this.activityPane.setXmlText("");
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                int n = ActivityTable.this.table.getSelectedRow();
                if (n >= 0 && mouseEvent.isPopupTrigger()) {
                    ActivityData activityData = ActivityTable.this.model.getActivity(n);
                    if (activityData.isActive()) {
                        ActivityTable.this.menuStop.setEnabled(true);
                    } else {
                        ActivityTable.this.menuStop.setEnabled(false);
                    }
                    ActivityTable.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.menuStop) {
            int n = this.table.getSelectedRow();
            if (n >= 0) {
                int n2 = this.model.getActivity(n).getActivityId();
                this.activityManager.stopActivity(n2);
            }
        } else if (actionEvent.getSource() == this.menuRemove) {
            this.removeSelectedActivity();
        }
    }

    private void removeSelectedActivity() {
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            ActivityData activityData = this.model.getActivity(n);
            if (activityData.isActive()) {
                this.activityManager.stopActivity(activityData.getActivityId());
            }
            this.activityPane.setXmlText("");
            this.model.removeActivity(activityData.getActivityId());
        }
    }

    protected JScrollPane getTable() {
        return this.scrollPane;
    }
}

