/*
 * Decompiled with CFR 0.152.
 */
package gui.tab;

import activity.ActivityManager;
import gui.tab.ActivityTable;
import gui.tab.ActivityTableModel;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class ActivityTab
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ActivityManager activityManager;
    private JTabbedPane tabbedPane;
    private int runningActivitiesNum;
    private ActivityTable activityTable;
    public ActivityTableModel activityTableModel;
    private JTextArea xmlArea;

    public ActivityTab(ActivityManager activityManager, JTabbedPane jTabbedPane) {
        this.activityManager = activityManager;
        this.tabbedPane = jTabbedPane;
        this.runningActivitiesNum = 0;
        this.setLayout(new GridLayout(1, 1));
        this.activityTableModel = new ActivityTableModel();
        this.activityTable = new ActivityTable(this, this.activityTableModel, activityManager);
        JScrollPane jScrollPane = this.activityTable.getTable();
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Activity list"));
        this.xmlArea = new JTextArea();
        this.xmlArea.getInputMap().put(KeyStroke.getKeyStroke("ctrl DELETE"), "none");
        this.xmlArea.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.xmlArea);
        jScrollPane2.setPreferredSize(new Dimension(0, 250));
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("XML"));
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jSplitPane.setResizeWeight(1.0);
        this.add(jSplitPane);
    }

    protected void setXmlText(String string) {
        this.xmlArea.setText(string);
        this.xmlArea.setCaretPosition(0);
    }

    public void updateNumberActivities() {
        int n = this.activityManager.getRunningActivitiesNum();
        if (n != this.runningActivitiesNum) {
            this.runningActivitiesNum = n;
            this.tabbedPane.setTitleAt(1, "Activities (" + n + ")");
        }
    }

    public void clearAll() {
        this.xmlArea.setText("");
        this.activityTableModel.clear();
    }
}

