/*
 * Decompiled with CFR 0.152.
 */
package gui;

import activity.ActivityManager;
import gui.AddClientDialog;
import gui.ConnectDialog;
import gui.GUI;
import gui.LogToFileDialog;
import gui.tab.OverviewTab;
import gui.usermessages.SendDialog;
import gui.usermessages.ViewAllDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import network.ConnectionHandler;
import network.PacketHandler;
import network.SupervisionHandler;

public class Menu
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final GUI gui;
    private ConnectionHandler connectionHandler;
    private PacketHandler packetHandler;
    private OverviewTab overviewTab;
    private ActivityManager activityManager;
    private SupervisionHandler supervisionHandler;
    private JFrame frame;
    private JMenu fileMenu;
    private JMenu viewMenu;
    private JMenu systemMenu;
    private JMenu messagesMenu;
    private JMenu helpMenu;
    private JMenuItem fileConnect;
    private JMenuItem fileDisconnect;
    private JMenuItem fileLogToFile;
    private JMenuItem fileExit;
    private JCheckBoxMenuItem viewLogWindow;
    private JCheckBoxMenuItem viewDetailWindow;
    private JMenuItem viewOpenOverview;
    private JMenuItem viewOpenActivity;
    private JMenuItem viewClearTab;
    private JMenuItem viewClearAll;
    private JMenuItem systemAddClient;
    private JMenuItem systemRemoveClient;
    private JMenu systemSubscriptionStart;
    private JMenuItem systemStartUserData;
    private JMenuItem systemStartAlarm;
    private JMenu systemSubscriptionStop;
    private JMenuItem systemStopUserData;
    private JMenuItem systemStopAlarm;
    private JMenuItem messagesSend;
    private JMenuItem messagesEdit;
    private JMenuItem helpAbout;

    public Menu(GUI gUI, ConnectionHandler connectionHandler, PacketHandler packetHandler, OverviewTab overviewTab, ActivityManager activityManager, SupervisionHandler supervisionHandler, JFrame jFrame) {
        this.gui = gUI;
        this.connectionHandler = connectionHandler;
        this.packetHandler = packetHandler;
        this.overviewTab = overviewTab;
        this.activityManager = activityManager;
        this.supervisionHandler = supervisionHandler;
        this.frame = jFrame;
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic('V');
        this.systemMenu = new JMenu("System");
        this.systemMenu.setMnemonic('S');
        this.systemMenu.setEnabled(false);
        this.messagesMenu = new JMenu("Messages");
        this.messagesMenu.setMnemonic('M');
        this.messagesMenu.setEnabled(false);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic('H');
        this.add(this.fileMenu);
        this.add(this.viewMenu);
        this.add(this.systemMenu);
        this.add(this.messagesMenu);
        this.add(this.helpMenu);
        this.addFileMenu();
        this.addViewMenu();
        this.addSystemMenu();
        this.addMessagesMenu();
        this.addHelpMenu();
    }

    private void addFileMenu() {
        this.fileConnect = new JMenuItem("Connect...");
        this.fileConnect.setMnemonic('C');
        this.fileConnect.addActionListener(this);
        this.fileConnect.setActionCommand("connect");
        this.fileDisconnect = new JMenuItem("Disconnect");
        this.fileDisconnect.setEnabled(false);
        this.fileDisconnect.setMnemonic('D');
        this.fileDisconnect.addActionListener(this);
        this.fileDisconnect.setActionCommand("disconnect");
        this.fileLogToFile = new JMenuItem("Log to file...");
        this.fileLogToFile.setEnabled(true);
        this.fileLogToFile.setMnemonic('L');
        this.fileLogToFile.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        this.fileLogToFile.addActionListener(this);
        this.fileLogToFile.setActionCommand("logToFile");
        this.fileExit = new JMenuItem("Exit");
        this.fileExit.setMnemonic('X');
        this.fileExit.addActionListener(this);
        this.fileExit.setActionCommand("exit");
        this.fileMenu.add(this.fileConnect);
        this.fileMenu.add(this.fileDisconnect);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.fileLogToFile);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.fileExit);
    }

    private void addViewMenu() {
        this.viewLogWindow = new JCheckBoxMenuItem("View log window");
        boolean bl = GUI.prefs.getBoolean("overview.view_log_window", true);
        this.viewLogWindow.setSelected(bl);
        this.viewLogWindow.setMnemonic('L');
        this.viewLogWindow.addActionListener(this);
        this.viewLogWindow.setActionCommand("logWindow");
        this.viewDetailWindow = new JCheckBoxMenuItem("View detail window");
        boolean bl2 = GUI.prefs.getBoolean("overview.view_details_window", true);
        this.viewDetailWindow.setSelected(bl2);
        this.viewDetailWindow.setMnemonic('D');
        this.viewDetailWindow.addActionListener(this);
        this.viewDetailWindow.setActionCommand("detailWindow");
        this.viewOpenOverview = new JMenuItem("Open overview tab");
        this.viewOpenOverview.setMnemonic('O');
        this.viewOpenOverview.setAccelerator(KeyStroke.getKeyStroke("F1"));
        this.viewOpenOverview.addActionListener(this);
        this.viewOpenOverview.setActionCommand("openOverview");
        this.viewOpenActivity = new JMenuItem("Open activity tab");
        this.viewOpenActivity.setMnemonic('A');
        this.viewOpenActivity.setAccelerator(KeyStroke.getKeyStroke("F2"));
        this.viewOpenActivity.addActionListener(this);
        this.viewOpenActivity.setActionCommand("openActivity");
        this.viewClearTab = new JMenuItem("Clear current tab");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 2);
        this.viewClearTab.setAccelerator(keyStroke);
        this.viewClearTab.setMnemonic('C');
        this.viewClearTab.addActionListener(this);
        this.viewClearTab.setActionCommand("clearTab");
        this.viewClearAll = new JMenuItem("Clear all");
        this.viewClearAll.setAccelerator(KeyStroke.getKeyStroke("ctrl shift DELETE"));
        this.viewClearAll.setMnemonic('A');
        this.viewClearAll.addActionListener(this);
        this.viewClearAll.setActionCommand("clearAll");
        this.viewMenu.add(this.viewLogWindow);
        this.viewMenu.add(this.viewDetailWindow);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.viewOpenOverview);
        this.viewMenu.add(this.viewOpenActivity);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.viewClearTab);
        this.viewMenu.add(this.viewClearAll);
    }

    private void addSystemMenu() {
        this.systemAddClient = new JMenuItem("Add client...");
        this.systemAddClient.setMnemonic('A');
        this.systemAddClient.setAccelerator(KeyStroke.getKeyStroke(49, 128));
        this.systemAddClient.addActionListener(this);
        this.systemAddClient.setActionCommand("addClient");
        this.systemRemoveClient = new JMenuItem("Remove client");
        this.systemRemoveClient.setMnemonic('R');
        this.systemRemoveClient.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.systemRemoveClient.addActionListener(this);
        this.systemRemoveClient.setActionCommand("removeClient");
        this.systemSubscriptionStart = new JMenu("Start subscription");
        this.systemSubscriptionStart.setMnemonic('T');
        this.systemStartUserData = new JMenuItem("User data");
        this.systemStartUserData.setMnemonic('U');
        this.systemStartUserData.setAccelerator(KeyStroke.getKeyStroke(50, 128));
        this.systemStartUserData.addActionListener(this);
        this.systemStartUserData.setActionCommand("startUserData");
        this.systemStartAlarm = new JMenuItem("Alarm");
        this.systemStartAlarm.setMnemonic('A');
        this.systemStartAlarm.setAccelerator(KeyStroke.getKeyStroke(51, 128));
        this.systemStartAlarm.addActionListener(this);
        this.systemStartAlarm.setActionCommand("startAlarm");
        this.systemSubscriptionStart.add(this.systemStartUserData);
        this.systemSubscriptionStart.add(this.systemStartAlarm);
        this.systemSubscriptionStop = new JMenu("Stop subscription");
        this.systemSubscriptionStop.setMnemonic('O');
        this.systemStopUserData = new JMenuItem("User data");
        this.systemStopUserData.setMnemonic('U');
        this.systemStopUserData.addActionListener(this);
        this.systemStopUserData.setActionCommand("stopUserData");
        this.systemStopAlarm = new JMenuItem("Alarm");
        this.systemStopAlarm.setMnemonic('A');
        this.systemStopAlarm.addActionListener(this);
        this.systemStopAlarm.setActionCommand("stopAlarm");
        this.systemSubscriptionStop.add(this.systemStopUserData);
        this.systemSubscriptionStop.add(this.systemStopAlarm);
        this.systemMenu.add(this.systemAddClient);
        this.systemMenu.add(this.systemRemoveClient);
        this.systemMenu.addSeparator();
        this.systemMenu.add(this.systemSubscriptionStart);
        this.systemMenu.add(this.systemSubscriptionStop);
    }

    private void addMessagesMenu() {
        this.messagesSend = new JMenuItem("Send...");
        this.messagesSend.setAccelerator(KeyStroke.getKeyStroke("F5"));
        this.messagesSend.setMnemonic('s');
        this.messagesSend.addActionListener(this);
        this.messagesSend.setActionCommand("sendMessage");
        this.messagesEdit = new JMenuItem("Edit...");
        this.messagesEdit.setAccelerator(KeyStroke.getKeyStroke("F4"));
        this.messagesEdit.setMnemonic('e');
        this.messagesEdit.addActionListener(this);
        this.messagesEdit.setActionCommand("editMessages");
        this.messagesMenu.add(this.messagesSend);
        this.messagesMenu.add(this.messagesEdit);
    }

    private void addHelpMenu() {
        this.helpAbout = new JMenuItem("About...");
        this.helpAbout.setMnemonic('a');
        this.helpAbout.addActionListener(this);
        this.helpAbout.setActionCommand("about");
        this.helpMenu.add(this.helpAbout);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("connect")) {
            new ConnectDialog(this.connectionHandler, this.frame);
        } else if (string.equals("disconnect")) {
            this.overviewTab.log.appendSystemMessage("Disconnected from server");
            this.connectionHandler.disconnectWithoutReconnect();
            this.activityManager.stopAll();
        } else if (string.equals("logToFile")) {
            new LogToFileDialog(this.overviewTab.log, this.frame);
        } else if (string.equals("exit")) {
            System.exit(0);
        } else if (string.equals("logWindow")) {
            if (this.viewLogWindow.getState()) {
                this.overviewTab.viewLogWindow();
            } else {
                this.overviewTab.hideLogWindow();
            }
        } else if (string.equals("detailWindow")) {
            if (this.viewDetailWindow.getState()) {
                this.overviewTab.viewDetailWindow();
            } else {
                this.overviewTab.hideDetailWindow();
            }
        } else if (string.equals("openOverview")) {
            this.gui.openOverviewTab();
        } else if (string.equals("openActivity")) {
            this.gui.openActivityTab();
        } else if (string.equals("clearTab")) {
            this.gui.clearCurrentTab();
        } else if (string.equals("clearAll")) {
            this.gui.clearAll();
        } else if (string.equals("addClient")) {
            new AddClientDialog(this.frame, this.packetHandler, this.supervisionHandler);
        } else if (string.equals("removeClient")) {
            this.packetHandler.sendRemoveClient();
            this.supervisionHandler.stop();
        } else if (string.equals("startUserData")) {
            this.packetHandler.sendSubscriptionStartUserData();
        } else if (string.equals("startAlarm")) {
            this.packetHandler.sendSubscriptionStartAlarm();
        } else if (string.equals("stopUserData")) {
            this.packetHandler.sendSubscriptionStopUserData();
        } else if (string.equals("stopAlarm")) {
            this.packetHandler.sendSubscriptionStopAlarm();
        } else if (string.equals("sendMessage")) {
            new SendDialog(this.activityManager, this.frame);
        } else if (string.equals("editMessages")) {
            new ViewAllDialog(this.frame);
        } else if (string.equals("about")) {
            this.viewAboutWindow();
        }
    }

    private void viewAboutWindow() {
        String string = "About OAPTest\n";
        string = string + "Version: 1.1";
        JOptionPane.showMessageDialog(this.frame, string);
    }

    protected void setDisconnected() {
        this.fileConnect.setEnabled(true);
        this.fileDisconnect.setEnabled(false);
        this.systemMenu.setEnabled(false);
        this.messagesMenu.setEnabled(false);
    }

    protected void setConnected() {
        this.fileConnect.setEnabled(false);
        this.fileDisconnect.setEnabled(true);
        this.systemMenu.setEnabled(true);
        this.messagesMenu.setEnabled(true);
    }
}

