/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GUI;
import gui.MyGridBagConstraints;
import gui.tab.Log;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class LogToFileDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String PREFS_CURRENT_DIRECTORY = "log_to_file.current_directory";
    private static final String PREFS_CURRENT_FILENAME = "log_to_file.current_filename";
    private final Log log;
    private JFileChooser chooser;
    private JCheckBox enabledCheckBox;
    private JTextField fileField;
    private JButton fileBrowse;
    private JButton cancelButton;
    private JButton saveButton;
    private JLabel fileLabel;
    private JLabel enabledLabel;

    public LogToFileDialog(Log log, JFrame jFrame) {
        super(jFrame);
        this.log = log;
        this.setLayout(new GridBagLayout());
        this.enabledLabel = new JLabel("Log to file: ", 4);
        this.enabledLabel.setPreferredSize(new Dimension(67, 24));
        this.enabledCheckBox = new JCheckBox("Enabled");
        this.enabledCheckBox.addActionListener(this);
        this.enabledCheckBox.setSelected(log.getLogToFile());
        String string = log.getFilename();
        if (string == null) {
            string = GUI.prefs.get(PREFS_CURRENT_FILENAME, "");
        }
        this.fileLabel = new JLabel("File: ", 4);
        this.fileLabel.setPreferredSize(new Dimension(67, 24));
        this.fileField = new JTextField(string);
        this.fileField.setPreferredSize(new Dimension(250, 20));
        this.fileBrowse = new JButton("Browse");
        this.fileBrowse.addActionListener(this);
        this.updateFieldsVisibility();
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(this);
        this.saveButton.setPreferredSize(new Dimension(67, 23));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("close");
        this.add((Component)this.enabledLabel, new MyGridBagConstraints(0, 0));
        this.add((Component)this.enabledCheckBox, new MyGridBagConstraints(0, 1));
        this.add((Component)this.fileLabel, new MyGridBagConstraints(1, 0));
        this.add((Component)this.fileField, new MyGridBagConstraints(1, 1, 1, 3));
        this.add((Component)this.fileBrowse, new MyGridBagConstraints(1, 5));
        this.add((Component)this.saveButton, new MyGridBagConstraints(2, 0));
        this.add((Component)this.cancelButton, new MyGridBagConstraints(2, 1));
        this.getRootPane().setDefaultButton(this.saveButton);
        this.getRootPane().registerKeyboardAction(this, "close", KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setTitle("Log to file");
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fileBrowse) {
            int n;
            String string;
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
            }
            if (!(string = GUI.prefs.get(PREFS_CURRENT_DIRECTORY, "")).isEmpty()) {
                this.chooser.setCurrentDirectory(new File(string));
            }
            if ((n = this.chooser.showSaveDialog(this)) == 0) {
                String string2 = this.chooser.getSelectedFile().getAbsolutePath();
                String string3 = this.chooser.getCurrentDirectory().getAbsolutePath();
                this.fileField.setText(string2);
                GUI.prefs.put(PREFS_CURRENT_FILENAME, string2);
                GUI.prefs.put(PREFS_CURRENT_DIRECTORY, string3);
            }
        } else if (actionEvent.getActionCommand().equals("close")) {
            this.dispose();
        } else if (actionEvent.getSource() == this.enabledCheckBox) {
            this.updateFieldsVisibility();
        } else if (actionEvent.getSource() == this.saveButton) {
            this.log.setFilename(this.fileField.getText().trim());
            if (this.enabledCheckBox.isSelected()) {
                this.log.logToFile(true);
            } else {
                this.log.logToFile(false);
            }
            this.dispose();
        }
    }

    private void updateFieldsVisibility() {
        if (this.enabledCheckBox.isSelected()) {
            this.fileField.setEditable(true);
            this.fileBrowse.setEnabled(true);
        } else {
            this.fileField.setEditable(false);
            this.fileBrowse.setEnabled(false);
        }
    }
}

