/*
 * Decompiled with CFR 0.152.
 */
package gui;

import activity.ActivityData;
import activity.ActivityManager;
import gui.ConnectDialog;
import gui.Menu;
import gui.tab.ActivityTab;
import gui.tab.OverviewTab;
import gui.tab.Request;
import gui.tab.Response;
import java.awt.Dimension;
import java.util.Observable;
import java.util.Observer;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import network.Connection;
import network.ConnectionHandler;
import network.PacketHandler;
import network.SupervisionHandler;

public class GUI
implements Observer {
    public static final Preferences prefs = Preferences.userRoot().node("OAPTEST_PREFERENCES");
    private static Version version;
    private static final int TAB_INDEX_OVERVIEW = 0;
    private static final int TAB_INDEX_ACTIVITY = 1;
    private JFrame frame;
    private ConnectionHandler connectionHandler;
    private PacketHandler packetHandler;
    private ActivityManager activityManager;
    private SupervisionHandler supervisionHandler;
    private Menu menu;
    private JTabbedPane tabbedPane;
    private OverviewTab overviewTab;
    private ActivityTab activityTab;

    public GUI(ConnectionHandler connectionHandler, PacketHandler packetHandler, ActivityManager activityManager, SupervisionHandler supervisionHandler) {
        this.connectionHandler = connectionHandler;
        this.packetHandler = packetHandler;
        this.activityManager = activityManager;
        this.supervisionHandler = supervisionHandler;
    }

    public static synchronized Version getVersion() {
        return version;
    }

    public static synchronized void setVersion(Version version) {
        GUI.version = version;
    }

    public void initGui() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GUI.this.init();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private void init() {
        this.frame = new JFrame();
        this.tabbedPane = new JTabbedPane();
        this.overviewTab = new OverviewTab(this, this.packetHandler);
        this.activityTab = new ActivityTab(this.activityManager, this.tabbedPane);
        this.tabbedPane.addTab("Overview", this.overviewTab);
        this.tabbedPane.addTab("Activities (0)", this.activityTab);
        this.tabbedPane.setMnemonicAt(0, 79);
        this.tabbedPane.setMnemonicAt(1, 65);
        this.frame.add(this.tabbedPane);
        this.menu = new Menu(this, this.connectionHandler, this.packetHandler, this.overviewTab, this.activityManager, this.supervisionHandler, this.frame);
        this.frame.setJMenuBar(this.menu);
        this.frame.setPreferredSize(new Dimension(1000, 800));
        this.frame.pack();
        this.frame.setTitle("OAPTest - [disconnected]");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setVisible(true);
    }

    protected void clearCurrentTab() {
        switch (this.tabbedPane.getSelectedIndex()) {
            case 0: {
                this.overviewTab.clearAll();
                break;
            }
            case 1: {
                this.activityManager.clear();
                this.activityTab.clearAll();
            }
        }
    }

    protected void clearAll() {
        this.activityManager.clear();
        this.activityTab.clearAll();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.overviewTab.clearAll();
            }
        });
    }

    protected void openOverviewTab() {
        this.tabbedPane.setSelectedIndex(0);
    }

    protected void openActivityTab() {
        this.tabbedPane.setSelectedIndex(1);
    }

    public void viewConnectDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ConnectDialog(GUI.this.connectionHandler, GUI.this.frame);
            }
        });
    }

    public void setDisconnected() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.frame.setTitle("OAPTest - [disconnected]");
                GUI.this.menu.setDisconnected();
            }
        });
    }

    public void setConnected(final String string, final Connection.ConnectionType connectionType) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string2 = connectionType == Connection.ConnectionType.MULTIPLE ? "multiple" : "persistent";
                int n = (int)GUI.getVersion().value();
                GUI.this.frame.setTitle("OAPTest - [server: " + string + ", version: " + n + ", connection: " + string2 + "]");
                if (connectionType == Connection.ConnectionType.MULTIPLE) {
                    ((GUI)GUI.this).overviewTab.log.appendSystemMessage("Using server " + string + " and version " + n);
                } else {
                    ((GUI)GUI.this).overviewTab.log.appendSystemMessage("Connected to server " + string + " using version " + n);
                }
                GUI.this.menu.setConnected();
            }
        });
    }

    public void addResponse(final Request.Direction direction, final String string, int n, int n2, String string2, boolean bl) {
        final Response response = new Response(n, n2, string2, bl);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.overviewTab.addResponse(direction, string, response);
            }
        });
    }

    public void addRequest(Request.Direction direction, String string, String string2, String string3, String string4) {
        final Request request = new Request(direction, string, string2, string3, string4);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.overviewTab.addRequest(request);
            }
        });
    }

    public void addRequestSendError(final String string, final String string2, final String string3) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string4 = string3 == null ? "Failed to send request, Id: " + string2 : "Failed to send request (" + string3 + "), Id: " + string2;
                string4 = string4 + ", Service: '";
                string4 = string4 + (string != null ? string : "<Unknown>");
                string4 = string4 + "'";
                ((GUI)GUI.this).overviewTab.log.appendErrorMessage(string4);
                GUI.this.overviewTab.addSendError(Request.Direction.OUT, string2);
            }
        });
    }

    public void addResponseSendError(final String string, final String string2, final String string3) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string4 = string3 == null ? "Failed to send response, Id: " + string2 : "Failed to send response (" + string3 + "), Id: " + string2;
                string4 = string4 + ", Service: '";
                string4 = string4 + (string != null ? string : "<Unknown>");
                string4 = string4 + "'";
                ((GUI)GUI.this).overviewTab.log.appendErrorMessage(string4);
                GUI.this.overviewTab.addSendError(Request.Direction.IN, string2);
            }
        });
    }

    public void logMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((GUI)GUI.this).overviewTab.log.appendMessage(string);
            }
        });
    }

    public void logSystemMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((GUI)GUI.this).overviewTab.log.appendSystemMessage(string);
            }
        });
    }

    public void logErrorMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((GUI)GUI.this).overviewTab.log.appendErrorMessage(string);
            }
        });
    }

    public void addActivity(final ActivityData activityData) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.activityTab.updateNumberActivities();
                ((GUI)GUI.this).activityTab.activityTableModel.addActivity(activityData);
            }
        });
    }

    public void removeActivity(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.activityTab.updateNumberActivities();
                ((GUI)GUI.this).activityTab.activityTableModel.removeActivity(n);
            }
        });
    }

    @Override
    public void update(final Observable observable, Object object) {
        if (observable instanceof ActivityData) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GUI.this.activityTab.updateNumberActivities();
                    ((GUI)GUI.this).activityTab.activityTableModel.activityUpdated((ActivityData)observable);
                }
            });
        }
    }

    public static enum Version {
        V3(3.0),
        V4(4.0),
        VBAD(2.0);

        private final double value;

        private Version(double d) {
            this.value = d;
        }

        public double value() {
            return this.value;
        }

        public static Version getVersion(int n) {
            if (n == 3) {
                return V3;
            }
            if (n == 4) {
                return V4;
            }
            if (n == 2) {
                return VBAD;
            }
            return null;
        }
    }
}

