/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import network.Connection;
import network.ConnectionHandler;

public class ConnectDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String PREFS_HOST = "connect.hostname";
    private static final String PREFS_VERSION = "add_client.version";
    private static final String PREFS_CONNECTION_TYPE = "add_client.connection_type";
    private static final String PREFS_SERVER_PORT = "add_client.server_port";
    private static final String PREFS_USE_DEFAULT_PORT = "add_client.use_default_port";
    private static final String PREFS_AUTO_RECONNECT = "add_client.auto_reconnect";
    private ConnectionHandler connectionHandler;
    private JTextField hostField;
    private JComboBox versionBox;
    private JComboBox connectionBox;
    private JCheckBox autoReconnectCheckBox;
    private JTextField serverPortField;
    private JCheckBox useDefaultPortCheckBox;
    private JButton connectButton;
    private JButton cancelButton;

    public ConnectDialog(ConnectionHandler connectionHandler, JFrame jFrame) {
        super(jFrame);
        this.connectionHandler = connectionHandler;
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Hostname: ", 4);
        jLabel.setPreferredSize(new Dimension(150, 20));
        this.hostField = new JTextField(GUI.prefs.get(PREFS_HOST, ""));
        this.hostField.setPreferredSize(new Dimension(150, 20));
        JLabel jLabel2 = new JLabel("Version: ", 4);
        this.versionBox = new JComboBox<String>(new String[]{"Version 3", "Version 4"});
        int n = GUI.prefs.getInt(PREFS_VERSION, 0);
        if (n == 0) {
            this.versionBox.setSelectedIndex(0);
        } else {
            this.versionBox.setSelectedIndex(1);
        }
        JLabel jLabel3 = new JLabel("Server port: ", 4);
        boolean bl = GUI.prefs.getBoolean(PREFS_USE_DEFAULT_PORT, true);
        this.useDefaultPortCheckBox = new JCheckBox("Use default port");
        this.useDefaultPortCheckBox.addActionListener(this);
        this.useDefaultPortCheckBox.setSelected(bl);
        this.serverPortField = new JTextField(String.valueOf(GUI.prefs.getInt(PREFS_SERVER_PORT, 1321)));
        this.serverPortField.setEditable(!bl);
        JLabel jLabel4 = new JLabel("Connection type: ", 4);
        this.connectionBox = new JComboBox<String>(new String[]{"Persistent connection", "Multiple connections"});
        this.connectionBox.addActionListener(this);
        int n2 = GUI.prefs.getInt(PREFS_CONNECTION_TYPE, 0);
        boolean bl2 = n2 == 0;
        this.autoReconnectCheckBox = new JCheckBox("Auto reconnect");
        this.autoReconnectCheckBox.setSelected(GUI.prefs.getBoolean(PREFS_AUTO_RECONNECT, true));
        this.autoReconnectCheckBox.setEnabled(bl2);
        if (n2 == 0) {
            this.connectionBox.setSelectedIndex(0);
        } else {
            this.connectionBox.setSelectedIndex(1);
        }
        this.connectButton = new JButton("Connect");
        this.connectButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("close");
        this.add(this.hostField, 0, 1);
        this.add(jLabel, 0, 0);
        this.add(jLabel2, 1, 0);
        this.add(this.versionBox, 1, 1);
        this.add(jLabel3, 2, 0);
        this.add(this.useDefaultPortCheckBox, 2, 1);
        this.add(this.serverPortField, 3, 1);
        this.add(jLabel4, 4, 0);
        this.add(this.connectionBox, 4, 1);
        this.add(this.autoReconnectCheckBox, 5, 1);
        this.add(this.connectButton, 6, 0);
        this.add(this.cancelButton, 6, 1);
        this.getRootPane().setDefaultButton(this.connectButton);
        this.getRootPane().registerKeyboardAction(this, "close", KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setTitle("Connect");
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private void add(JComponent jComponent, int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = n2;
        this.add((Component)jComponent, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.connectButton) {
            int n;
            final String string = this.hostField.getText();
            GUI.Version version = this.versionBox.getSelectedIndex() == 0 ? GUI.Version.V3 : GUI.Version.V4;
            final Connection.ConnectionType connectionType = this.connectionBox.getSelectedIndex() == 0 ? Connection.ConnectionType.PERSISTENT : Connection.ConnectionType.MULTIPLE;
            final boolean bl = this.autoReconnectCheckBox.isSelected();
            final boolean bl2 = this.useDefaultPortCheckBox.isSelected();
            try {
                n = Integer.valueOf(this.serverPortField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Failed to parse server port number.");
                return;
            }
            GUI.prefs.put(PREFS_HOST, string);
            GUI.prefs.putInt(PREFS_VERSION, this.versionBox.getSelectedIndex());
            GUI.prefs.putInt(PREFS_CONNECTION_TYPE, this.connectionBox.getSelectedIndex());
            GUI.prefs.putBoolean(PREFS_AUTO_RECONNECT, bl);
            GUI.prefs.putBoolean(PREFS_USE_DEFAULT_PORT, bl2);
            GUI.prefs.putInt(PREFS_SERVER_PORT, n);
            GUI.setVersion(version);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ConnectDialog.this.connectionHandler.setConnectionType(connectionType);
                    ConnectDialog.this.connectionHandler.connect(string, bl2, n, bl);
                }
            }, "ConnectThread").start();
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("close")) {
            this.dispose();
        } else if (actionEvent.getSource() == this.useDefaultPortCheckBox) {
            this.serverPortField.setEditable(!this.useDefaultPortCheckBox.isSelected());
        } else if (actionEvent.getSource() == this.connectionBox) {
            if (this.connectionBox.getSelectedIndex() == 0) {
                this.autoReconnectCheckBox.setEnabled(true);
            } else {
                this.autoReconnectCheckBox.setEnabled(false);
            }
        }
    }
}

