/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import network.PacketHandler;
import network.SupervisionHandler;

public class AddClientDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String PREFS_SUPERVISION_TIME = "add_client.supervision_time";
    private static final String PREFS_SEND_SUPERVISION = "add_client.send_supervision";
    private JFrame frame;
    private PacketHandler packetHandler;
    private SupervisionHandler supervisionHandler;
    private JTextField timeField;
    private JCheckBox supervisionBox;
    private JButton sendButton;
    private JButton cancelButton;

    public AddClientDialog(JFrame jFrame, PacketHandler packetHandler, SupervisionHandler supervisionHandler) {
        this.frame = jFrame;
        this.packetHandler = packetHandler;
        this.supervisionHandler = supervisionHandler;
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Supervision time (10-900):");
        int n = GUI.prefs.getInt(PREFS_SUPERVISION_TIME, 900);
        this.timeField = new JTextField(String.valueOf(n));
        this.timeField.setPreferredSize(new Dimension(127, 20));
        boolean bl = GUI.prefs.getBoolean(PREFS_SEND_SUPERVISION, true);
        this.timeField.setEditable(bl);
        this.supervisionBox = new JCheckBox("Send supervision");
        this.supervisionBox.addActionListener(this);
        this.supervisionBox.setSelected(bl);
        this.sendButton = new JButton("Send");
        this.sendButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("close");
        this.add(this.timeField, 0, 1);
        this.add(jLabel, 0, 0);
        this.add(this.supervisionBox, 1, 1);
        this.add(this.sendButton, 2, 0);
        this.add(this.cancelButton, 2, 1);
        this.getRootPane().setDefaultButton(this.sendButton);
        this.getRootPane().registerKeyboardAction(this, "close", KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setTitle("Add client");
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private void add(JComponent jComponent, int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = n2;
        this.add((Component)jComponent, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.sendButton) {
            int n = 900;
            try {
                n = Integer.valueOf(this.timeField.getText());
                boolean bl = this.supervisionBox.isSelected();
                this.packetHandler.sendAddClient(n, bl);
                if (bl) {
                    this.supervisionHandler.start(n);
                }
                GUI.prefs.putInt(PREFS_SUPERVISION_TIME, n);
                GUI.prefs.putBoolean(PREFS_SEND_SUPERVISION, bl);
                this.dispose();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.frame, "Error! Your input was not a number.");
            }
        } else if (actionEvent.getActionCommand().equals("close")) {
            this.dispose();
        } else if (actionEvent.getSource() == this.supervisionBox) {
            this.timeField.setEditable(this.supervisionBox.isSelected());
        }
    }
}

