/*
 * Decompiled with CFR 0.152.
 */
package activity;

import activity.ActivityData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IdRegister {
    private HashMap<Long, Value> map;
    private long lastTimeCleaned = System.currentTimeMillis() + this.TTLValue * 2L;
    private long TTLValue = 600000L;

    public IdRegister() {
        this.map = new HashMap();
    }

    public synchronized void registerRequest(long l, ActivityData activityData) {
        this.removeOldEntries();
        this.map.put(new Long(l), new Value(activityData));
    }

    public synchronized void removeRequest(Long l) {
        this.map.remove(l);
    }

    public synchronized boolean registerResponse(Long l, int n, int n2) {
        Value value = this.map.get(l);
        if (value != null && value.activityData != null) {
            value.activityData.addResponse(l, n, n2);
            return true;
        }
        return value != null;
    }

    public synchronized void clear() {
        this.map.clear();
    }

    private void removeOldEntries() {
        long l = System.currentTimeMillis();
        if (l - this.lastTimeCleaned > this.TTLValue) {
            Iterator<Map.Entry<Long, Value>> iterator = this.map.entrySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Map.Entry<Long, Value> entry = iterator.next();
                if (l - entry.getValue().timeAdded <= this.TTLValue) continue;
                iterator.remove();
                ++n;
            }
            this.lastTimeCleaned = l;
        }
    }

    private class Value {
        private ActivityData activityData;
        private long timeAdded;

        public Value(ActivityData activityData) {
            this.activityData = activityData;
            this.timeAdded = System.currentTimeMillis();
        }
    }
}

