/*
 * Decompiled with CFR 0.152.
 */
package activity;

import activity.Activity;
import activity.ActivityData;
import activity.IdRegister;
import gui.GUI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import network.PacketHandler;
import org.w3c.dom.Document;
import utils.XML;

public class ActivityManager {
    private PacketHandler packetHandler;
    private IdRegister idRegister;
    private GUI gui;
    private HashMap<Integer, Activity> hashMap;
    private int runningActivitiesNum;
    private int id;

    public ActivityManager(PacketHandler packetHandler, IdRegister idRegister) {
        this.packetHandler = packetHandler;
        this.idRegister = idRegister;
        this.hashMap = new HashMap();
        this.id = 1;
        this.runningActivitiesNum = 0;
    }

    public void setGui(GUI gUI) {
        this.gui = gUI;
    }

    public synchronized int addActivity(int n, int n2, int n3, PacketHandler.PacketInfo packetInfo) {
        String string;
        Object object;
        String string2 = this.packetHandler.getRequestXml(packetInfo);
        try {
            object = XML.getDocument(string2, null);
            string = this.packetHandler.getService((Document)object);
        }
        catch (Exception exception) {
            string = "<unknown, XML parse error>";
        }
        object = new ActivityData(this.idRegister, n, n2, n3, string, string2, this.id);
        ((Observable)object).addObserver(this.gui);
        Activity activity = new Activity(this, this.packetHandler, (ActivityData)object, this.gui, packetInfo);
        this.hashMap.put(new Integer(this.id), activity);
        activity.start();
        this.gui.addActivity((ActivityData)object);
        ++this.runningActivitiesNum;
        return this.id++;
    }

    public synchronized void stopActivity(int n) {
        Activity activity = this.hashMap.get(n);
        if (activity != null) {
            --this.runningActivitiesNum;
            activity.interrupt();
        }
    }

    protected synchronized void activityCompleted() {
        --this.runningActivitiesNum;
    }

    public synchronized void clear() {
        Iterator<Activity> iterator = this.hashMap.values().iterator();
        while (iterator.hasNext()) {
            Activity activity = iterator.next();
            activity.interrupt();
            try {
                activity.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            iterator.remove();
        }
        this.idRegister.clear();
        this.runningActivitiesNum = 0;
    }

    public synchronized void stopAll() {
        for (Activity activity : this.hashMap.values()) {
            activity.interrupt();
        }
        this.runningActivitiesNum = 0;
    }

    public synchronized int getRunningActivitiesNum() {
        return this.runningActivitiesNum;
    }
}

