/*
 * Decompiled with CFR 0.152.
 */
package activity;

import activity.IdRegister;
import java.util.Observable;

public class ActivityData
extends Observable {
    private static final int CODE_SUCCESS = 1;
    private static final int CODE_CONGESTION = 2;
    private static final int CODE_FAILURE = 3;
    private IdRegister idRegister;
    private final int period;
    private final int transmissions;
    private final String xmlPreview;
    private final int requireResponseType;
    private final int activityId;
    private final String service;
    private int packetsSent;
    private int packetsTcpIpErrors;
    private int packetsSuccess;
    private int packetsCongestion;
    private int packetsFailure;
    private int packetsPending;
    private int packetsMaxPending;
    private boolean active;

    public ActivityData(IdRegister idRegister, int n, int n2, int n3, String string, String string2, int n4) {
        this.idRegister = idRegister;
        this.period = n;
        this.transmissions = n2;
        this.requireResponseType = n3;
        this.service = string;
        this.xmlPreview = string2;
        this.activityId = n4;
        this.packetsSent = 0;
        this.packetsTcpIpErrors = 0;
        this.packetsSuccess = 0;
        this.packetsCongestion = 0;
        this.packetsFailure = 0;
        this.packetsPending = 0;
        this.packetsMaxPending = 0;
        this.active = true;
    }

    public synchronized void increasePacketsSent() {
        ++this.packetsSent;
        ++this.packetsPending;
        if (this.packetsPending > this.packetsMaxPending) {
            this.packetsMaxPending = this.packetsPending;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void addRequestSendError() {
        ++this.packetsTcpIpErrors;
        --this.packetsPending;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void setActive(boolean bl) {
        this.active = bl;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized int getTransmissions() {
        return this.transmissions;
    }

    public synchronized String getXmlPreview() {
        return this.xmlPreview;
    }

    public synchronized int getPeriod() {
        return this.period;
    }

    public synchronized int getActivityId() {
        return this.activityId;
    }

    public synchronized String getService() {
        return this.service;
    }

    public synchronized String toString() {
        return "Activity #" + this.activityId;
    }

    public synchronized int getTcpIpErrors() {
        return this.packetsTcpIpErrors;
    }

    public synchronized int getPacketsSent() {
        return this.packetsSent;
    }

    public synchronized int getPacketsSuccess() {
        return this.packetsSuccess;
    }

    public synchronized int getPacketsCongestion() {
        return this.packetsCongestion;
    }

    public synchronized int getPacketsFailure() {
        return this.packetsFailure;
    }

    public synchronized int getPacketsPending() {
        return this.packetsPending;
    }

    public synchronized int getPacketsMaxPending() {
        return this.packetsMaxPending;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized void addResponse(Long l, int n, int n2) {
        int n3 = 3;
        if (n2 == 200) {
            n3 = 1;
        } else if (n2 >= 300 && n2 < 400) {
            n3 = 2;
        } else if (n2 >= 400 && n2 < 500) {
            n3 = 3;
        }
        if (this.requireResponseType == n && n == 2) {
            ++this.packetsSuccess;
            --this.packetsPending;
        } else if (this.requireResponseType == n) {
            switch (n3) {
                case 1: {
                    ++this.packetsSuccess;
                    break;
                }
                case 2: {
                    ++this.packetsCongestion;
                    break;
                }
                case 3: {
                    ++this.packetsFailure;
                }
            }
            --this.packetsPending;
            this.idRegister.removeRequest(l);
        } else if (n == 1) {
            switch (n3) {
                case 2: {
                    ++this.packetsCongestion;
                    --this.packetsPending;
                    break;
                }
                case 3: {
                    ++this.packetsFailure;
                    --this.packetsPending;
                }
            }
        }
        this.setChanged();
        this.notifyObservers();
    }
}

